package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.braket.model.primitives.QuantumTaskArn
import scala.jdk.CollectionConverters.*
final case class GetQuantumTaskRequest(
    additionalAttributeNames: Optional[
      Iterable[zio.aws.braket.model.QuantumTaskAdditionalAttributeName]
    ] = Optional.Absent,
    quantumTaskArn: QuantumTaskArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.GetQuantumTaskRequest = {
    import GetQuantumTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.GetQuantumTaskRequest
      .builder()
      .optionallyWith(
        additionalAttributeNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.additionalAttributeNamesWithStrings)
      .quantumTaskArn(QuantumTaskArn.unwrap(quantumTaskArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.GetQuantumTaskRequest.ReadOnly =
    zio.aws.braket.model.GetQuantumTaskRequest.wrap(buildAwsValue())
}
object GetQuantumTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.GetQuantumTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.GetQuantumTaskRequest =
      zio.aws.braket.model.GetQuantumTaskRequest(
        additionalAttributeNames.map(value => value),
        quantumTaskArn
      )
    def additionalAttributeNames: Optional[
      List[zio.aws.braket.model.QuantumTaskAdditionalAttributeName]
    ]
    def quantumTaskArn: QuantumTaskArn
    def getAdditionalAttributeNames: ZIO[Any, AwsError, List[
      zio.aws.braket.model.QuantumTaskAdditionalAttributeName
    ]] = AwsError.unwrapOptionField(
      "additionalAttributeNames",
      additionalAttributeNames
    )
    def getQuantumTaskArn: ZIO[Any, Nothing, QuantumTaskArn] =
      ZIO.succeed(quantumTaskArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.GetQuantumTaskRequest
  ) extends zio.aws.braket.model.GetQuantumTaskRequest.ReadOnly {
    override val additionalAttributeNames: Optional[
      List[zio.aws.braket.model.QuantumTaskAdditionalAttributeName]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalAttributeNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.braket.model.QuantumTaskAdditionalAttributeName.wrap(item)
        }.toList
      )
    override val quantumTaskArn: QuantumTaskArn =
      zio.aws.braket.model.primitives.QuantumTaskArn(impl.quantumTaskArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.GetQuantumTaskRequest
  ): zio.aws.braket.model.GetQuantumTaskRequest.ReadOnly = new Wrapper(impl)
}
