package zio.aws.braket.model
import zio.aws.braket.model.primitives.{
  HyperParametersValueString,
  RoleArn,
  String1024,
  JobArn,
  SyntheticTimestamp_date_time,
  Integer,
  GetJobResponseJobNameString,
  String256
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetJobResponse(
    algorithmSpecification: zio.aws.braket.model.AlgorithmSpecification,
    billableDuration: Optional[Integer] = Optional.Absent,
    checkpointConfig: Optional[zio.aws.braket.model.JobCheckpointConfig] =
      Optional.Absent,
    createdAt: SyntheticTimestamp_date_time,
    deviceConfig: Optional[zio.aws.braket.model.DeviceConfig] = Optional.Absent,
    endedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    events: Optional[Iterable[zio.aws.braket.model.JobEventDetails]] =
      Optional.Absent,
    failureReason: Optional[String1024] = Optional.Absent,
    hyperParameters: Optional[Map[String256, HyperParametersValueString]] =
      Optional.Absent,
    inputDataConfig: Optional[Iterable[zio.aws.braket.model.InputFileConfig]] =
      Optional.Absent,
    instanceConfig: zio.aws.braket.model.InstanceConfig,
    jobArn: JobArn,
    jobName: GetJobResponseJobNameString,
    outputDataConfig: zio.aws.braket.model.JobOutputDataConfig,
    queueInfo: Optional[zio.aws.braket.model.HybridJobQueueInfo] =
      Optional.Absent,
    roleArn: RoleArn,
    startedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    status: zio.aws.braket.model.JobPrimaryStatus,
    stoppingCondition: Optional[zio.aws.braket.model.JobStoppingCondition] =
      Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.GetJobResponse = {
    import GetJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.GetJobResponse
      .builder()
      .algorithmSpecification(algorithmSpecification.buildAwsValue())
      .optionallyWith(billableDuration.map(value => value: java.lang.Integer))(
        _.billableDuration
      )
      .optionallyWith(checkpointConfig.map(value => value.buildAwsValue()))(
        _.checkpointConfig
      )
      .createdAt(SyntheticTimestamp_date_time.unwrap(createdAt): Instant)
      .optionallyWith(deviceConfig.map(value => value.buildAwsValue()))(
        _.deviceConfig
      )
      .optionallyWith(
        endedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.endedAt)
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .optionallyWith(
        failureReason.map(value => String1024.unwrap(value): java.lang.String)
      )(_.failureReason)
      .optionallyWith(
        hyperParameters.map(value =>
          value
            .map({ case (key, value) =>
              (String256.unwrap(
                key
              ): java.lang.String) -> (HyperParametersValueString.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.hyperParameters)
      .optionallyWith(
        inputDataConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDataConfig)
      .instanceConfig(instanceConfig.buildAwsValue())
      .jobArn(JobArn.unwrap(jobArn): java.lang.String)
      .jobName(GetJobResponseJobNameString.unwrap(jobName): java.lang.String)
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .optionallyWith(queueInfo.map(value => value.buildAwsValue()))(
        _.queueInfo
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        startedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.startedAt)
      .status(status.unwrap)
      .optionallyWith(stoppingCondition.map(value => value.buildAwsValue()))(
        _.stoppingCondition
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.GetJobResponse.ReadOnly =
    zio.aws.braket.model.GetJobResponse.wrap(buildAwsValue())
}
object GetJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.GetJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.GetJobResponse =
      zio.aws.braket.model.GetJobResponse(
        algorithmSpecification.asEditable,
        billableDuration.map(value => value),
        checkpointConfig.map(value => value.asEditable),
        createdAt,
        deviceConfig.map(value => value.asEditable),
        endedAt.map(value => value),
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failureReason.map(value => value),
        hyperParameters.map(value => value),
        inputDataConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceConfig.asEditable,
        jobArn,
        jobName,
        outputDataConfig.asEditable,
        queueInfo.map(value => value.asEditable),
        roleArn,
        startedAt.map(value => value),
        status,
        stoppingCondition.map(value => value.asEditable),
        tags.map(value => value)
      )
    def algorithmSpecification
        : zio.aws.braket.model.AlgorithmSpecification.ReadOnly
    def billableDuration: Optional[Integer]
    def checkpointConfig
        : Optional[zio.aws.braket.model.JobCheckpointConfig.ReadOnly]
    def createdAt: SyntheticTimestamp_date_time
    def deviceConfig: Optional[zio.aws.braket.model.DeviceConfig.ReadOnly]
    def endedAt: Optional[SyntheticTimestamp_date_time]
    def events: Optional[List[zio.aws.braket.model.JobEventDetails.ReadOnly]]
    def failureReason: Optional[String1024]
    def hyperParameters: Optional[Map[String256, HyperParametersValueString]]
    def inputDataConfig
        : Optional[List[zio.aws.braket.model.InputFileConfig.ReadOnly]]
    def instanceConfig: zio.aws.braket.model.InstanceConfig.ReadOnly
    def jobArn: JobArn
    def jobName: GetJobResponseJobNameString
    def outputDataConfig: zio.aws.braket.model.JobOutputDataConfig.ReadOnly
    def queueInfo: Optional[zio.aws.braket.model.HybridJobQueueInfo.ReadOnly]
    def roleArn: RoleArn
    def startedAt: Optional[SyntheticTimestamp_date_time]
    def status: zio.aws.braket.model.JobPrimaryStatus
    def stoppingCondition
        : Optional[zio.aws.braket.model.JobStoppingCondition.ReadOnly]
    def tags: Optional[Map[String, String]]
    def getAlgorithmSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.braket.model.AlgorithmSpecification.ReadOnly
    ] = ZIO.succeed(algorithmSpecification)
    def getBillableDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("billableDuration", billableDuration)
    def getCheckpointConfig: ZIO[
      Any,
      AwsError,
      zio.aws.braket.model.JobCheckpointConfig.ReadOnly
    ] = AwsError.unwrapOptionField("checkpointConfig", checkpointConfig)
    def getCreatedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(createdAt)
    def getDeviceConfig
        : ZIO[Any, AwsError, zio.aws.braket.model.DeviceConfig.ReadOnly] =
      AwsError.unwrapOptionField("deviceConfig", deviceConfig)
    def getEndedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("endedAt", endedAt)
    def getEvents: ZIO[Any, AwsError, List[
      zio.aws.braket.model.JobEventDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
    def getFailureReason: ZIO[Any, AwsError, String1024] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getHyperParameters
        : ZIO[Any, AwsError, Map[String256, HyperParametersValueString]] =
      AwsError.unwrapOptionField("hyperParameters", hyperParameters)
    def getInputDataConfig: ZIO[Any, AwsError, List[
      zio.aws.braket.model.InputFileConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getInstanceConfig
        : ZIO[Any, Nothing, zio.aws.braket.model.InstanceConfig.ReadOnly] =
      ZIO.succeed(instanceConfig)
    def getJobArn: ZIO[Any, Nothing, JobArn] = ZIO.succeed(jobArn)
    def getJobName: ZIO[Any, Nothing, GetJobResponseJobNameString] =
      ZIO.succeed(jobName)
    def getOutputDataConfig
        : ZIO[Any, Nothing, zio.aws.braket.model.JobOutputDataConfig.ReadOnly] =
      ZIO.succeed(outputDataConfig)
    def getQueueInfo
        : ZIO[Any, AwsError, zio.aws.braket.model.HybridJobQueueInfo.ReadOnly] =
      AwsError.unwrapOptionField("queueInfo", queueInfo)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStartedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getStatus: ZIO[Any, Nothing, zio.aws.braket.model.JobPrimaryStatus] =
      ZIO.succeed(status)
    def getStoppingCondition: ZIO[
      Any,
      AwsError,
      zio.aws.braket.model.JobStoppingCondition.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingCondition", stoppingCondition)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.GetJobResponse
  ) extends zio.aws.braket.model.GetJobResponse.ReadOnly {
    override val algorithmSpecification
        : zio.aws.braket.model.AlgorithmSpecification.ReadOnly =
      zio.aws.braket.model.AlgorithmSpecification
        .wrap(impl.algorithmSpecification())
    override val billableDuration: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.billableDuration())
      .map(value => value: Integer)
    override val checkpointConfig
        : Optional[zio.aws.braket.model.JobCheckpointConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkpointConfig())
        .map(value => zio.aws.braket.model.JobCheckpointConfig.wrap(value))
    override val createdAt: SyntheticTimestamp_date_time =
      zio.aws.braket.model.primitives
        .SyntheticTimestamp_date_time(impl.createdAt())
    override val deviceConfig
        : Optional[zio.aws.braket.model.DeviceConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceConfig())
        .map(value => zio.aws.braket.model.DeviceConfig.wrap(value))
    override val endedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endedAt())
        .map(value =>
          zio.aws.braket.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val events
        : Optional[List[zio.aws.braket.model.JobEventDetails.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.braket.model.JobEventDetails.wrap(item)
          }.toList
        )
    override val failureReason: Optional[String1024] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.braket.model.primitives.String1024(value))
    override val hyperParameters
        : Optional[Map[String256, HyperParametersValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hyperParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.braket.model.primitives
                .String256(key) -> zio.aws.braket.model.primitives
                .HyperParametersValueString(value)
            })
            .toMap
        )
    override val inputDataConfig
        : Optional[List[zio.aws.braket.model.InputFileConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputDataConfig())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.braket.model.InputFileConfig.wrap(item)
          }.toList
        )
    override val instanceConfig: zio.aws.braket.model.InstanceConfig.ReadOnly =
      zio.aws.braket.model.InstanceConfig.wrap(impl.instanceConfig())
    override val jobArn: JobArn =
      zio.aws.braket.model.primitives.JobArn(impl.jobArn())
    override val jobName: GetJobResponseJobNameString =
      zio.aws.braket.model.primitives
        .GetJobResponseJobNameString(impl.jobName())
    override val outputDataConfig
        : zio.aws.braket.model.JobOutputDataConfig.ReadOnly =
      zio.aws.braket.model.JobOutputDataConfig.wrap(impl.outputDataConfig())
    override val queueInfo
        : Optional[zio.aws.braket.model.HybridJobQueueInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queueInfo())
        .map(value => zio.aws.braket.model.HybridJobQueueInfo.wrap(value))
    override val roleArn: RoleArn =
      zio.aws.braket.model.primitives.RoleArn(impl.roleArn())
    override val startedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startedAt())
        .map(value =>
          zio.aws.braket.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val status: zio.aws.braket.model.JobPrimaryStatus =
      zio.aws.braket.model.JobPrimaryStatus.wrap(impl.status())
    override val stoppingCondition
        : Optional[zio.aws.braket.model.JobStoppingCondition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stoppingCondition())
        .map(value => zio.aws.braket.model.JobStoppingCondition.wrap(value))
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.GetJobResponse
  ): zio.aws.braket.model.GetJobResponse.ReadOnly = new Wrapper(impl)
}
