package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.braket.model.primitives.JobArn
import scala.jdk.CollectionConverters.*
final case class GetJobRequest(
    additionalAttributeNames: Optional[
      Iterable[zio.aws.braket.model.HybridJobAdditionalAttributeName]
    ] = Optional.Absent,
    jobArn: JobArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.GetJobRequest = {
    import GetJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.GetJobRequest
      .builder()
      .optionallyWith(
        additionalAttributeNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.additionalAttributeNamesWithStrings)
      .jobArn(JobArn.unwrap(jobArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.GetJobRequest.ReadOnly =
    zio.aws.braket.model.GetJobRequest.wrap(buildAwsValue())
}
object GetJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.GetJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.GetJobRequest = zio.aws.braket.model
      .GetJobRequest(additionalAttributeNames.map(value => value), jobArn)
    def additionalAttributeNames
        : Optional[List[zio.aws.braket.model.HybridJobAdditionalAttributeName]]
    def jobArn: JobArn
    def getAdditionalAttributeNames: ZIO[Any, AwsError, List[
      zio.aws.braket.model.HybridJobAdditionalAttributeName
    ]] = AwsError.unwrapOptionField(
      "additionalAttributeNames",
      additionalAttributeNames
    )
    def getJobArn: ZIO[Any, Nothing, JobArn] = ZIO.succeed(jobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.GetJobRequest
  ) extends zio.aws.braket.model.GetJobRequest.ReadOnly {
    override val additionalAttributeNames: Optional[
      List[zio.aws.braket.model.HybridJobAdditionalAttributeName]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalAttributeNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.braket.model.HybridJobAdditionalAttributeName.wrap(item)
        }.toList
      )
    override val jobArn: JobArn =
      zio.aws.braket.model.primitives.JobArn(impl.jobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.GetJobRequest
  ): zio.aws.braket.model.GetJobRequest.ReadOnly = new Wrapper(impl)
}
