package zio.aws.braket.model
import scala.jdk.CollectionConverters.*
sealed trait DeviceStatus {
  def unwrap: software.amazon.awssdk.services.braket.model.DeviceStatus
}
object DeviceStatus {
  def wrap(
      value: software.amazon.awssdk.services.braket.model.DeviceStatus
  ): zio.aws.braket.model.DeviceStatus = value match {
    case software.amazon.awssdk.services.braket.model.DeviceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.braket.model.DeviceStatus.ONLINE =>
      val r = ONLINE
      r
    case software.amazon.awssdk.services.braket.model.DeviceStatus.OFFLINE =>
      val r = OFFLINE
      r
    case software.amazon.awssdk.services.braket.model.DeviceStatus.RETIRED =>
      val r = RETIRED
      r
  }
  case object unknownToSdkVersion extends zio.aws.braket.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.DeviceStatus =
      software.amazon.awssdk.services.braket.model.DeviceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ONLINE extends zio.aws.braket.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.DeviceStatus =
      software.amazon.awssdk.services.braket.model.DeviceStatus.ONLINE
  }
  case object OFFLINE extends zio.aws.braket.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.DeviceStatus =
      software.amazon.awssdk.services.braket.model.DeviceStatus.OFFLINE
  }
  case object RETIRED extends zio.aws.braket.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.DeviceStatus =
      software.amazon.awssdk.services.braket.model.DeviceStatus.RETIRED
  }
}
