package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeviceQueueInfo(
    queue: zio.aws.braket.model.QueueName,
    queuePriority: Optional[zio.aws.braket.model.QueuePriority] =
      Optional.Absent,
    queueSize: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.DeviceQueueInfo = {
    import DeviceQueueInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.DeviceQueueInfo
      .builder()
      .queue(queue.unwrap)
      .optionallyWith(queuePriority.map(value => value.unwrap))(_.queuePriority)
      .queueSize(queueSize: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.DeviceQueueInfo.ReadOnly =
    zio.aws.braket.model.DeviceQueueInfo.wrap(buildAwsValue())
}
object DeviceQueueInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.DeviceQueueInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.DeviceQueueInfo = zio.aws.braket.model
      .DeviceQueueInfo(queue, queuePriority.map(value => value), queueSize)
    def queue: zio.aws.braket.model.QueueName
    def queuePriority: Optional[zio.aws.braket.model.QueuePriority]
    def queueSize: String
    def getQueue: ZIO[Any, Nothing, zio.aws.braket.model.QueueName] =
      ZIO.succeed(queue)
    def getQueuePriority
        : ZIO[Any, AwsError, zio.aws.braket.model.QueuePriority] =
      AwsError.unwrapOptionField("queuePriority", queuePriority)
    def getQueueSize: ZIO[Any, Nothing, String] = ZIO.succeed(queueSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.DeviceQueueInfo
  ) extends zio.aws.braket.model.DeviceQueueInfo.ReadOnly {
    override val queue: zio.aws.braket.model.QueueName =
      zio.aws.braket.model.QueueName.wrap(impl.queue())
    override val queuePriority: Optional[zio.aws.braket.model.QueuePriority] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queuePriority())
        .map(value => zio.aws.braket.model.QueuePriority.wrap(value))
    override val queueSize: String = impl.queueSize(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.DeviceQueueInfo
  ): zio.aws.braket.model.DeviceQueueInfo.ReadOnly = new Wrapper(impl)
}
