package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.braket.model.primitives.Uri
import scala.jdk.CollectionConverters.*
final case class ContainerImage(uri: Uri) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.ContainerImage = {
    import ContainerImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.ContainerImage
      .builder()
      .uri(Uri.unwrap(uri): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.ContainerImage.ReadOnly =
    zio.aws.braket.model.ContainerImage.wrap(buildAwsValue())
}
object ContainerImage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.ContainerImage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.ContainerImage =
      zio.aws.braket.model.ContainerImage(uri)
    def uri: Uri
    def getUri: ZIO[Any, Nothing, Uri] = ZIO.succeed(uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.ContainerImage
  ) extends zio.aws.braket.model.ContainerImage.ReadOnly {
    override val uri: Uri = zio.aws.braket.model.primitives.Uri(impl.uri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.ContainerImage
  ): zio.aws.braket.model.ContainerImage.ReadOnly = new Wrapper(impl)
}
