package zio.aws.braket.model
import scala.jdk.CollectionConverters.*
sealed trait CancellationStatus {
  def unwrap: software.amazon.awssdk.services.braket.model.CancellationStatus
}
object CancellationStatus {
  def wrap(
      value: software.amazon.awssdk.services.braket.model.CancellationStatus
  ): zio.aws.braket.model.CancellationStatus = value match {
    case software.amazon.awssdk.services.braket.model.CancellationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.braket.model.CancellationStatus.CANCELLING =>
      val r = CANCELLING
      r
    case software.amazon.awssdk.services.braket.model.CancellationStatus.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.braket.model.CancellationStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.CancellationStatus =
      software.amazon.awssdk.services.braket.model.CancellationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CANCELLING extends zio.aws.braket.model.CancellationStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.CancellationStatus =
      software.amazon.awssdk.services.braket.model.CancellationStatus.CANCELLING
  }
  case object CANCELLED extends zio.aws.braket.model.CancellationStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.CancellationStatus =
      software.amazon.awssdk.services.braket.model.CancellationStatus.CANCELLED
  }
}
