package zio.aws.braket.model
import zio.aws.braket.model.primitives.SearchDevicesRequestMaxResultsInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchDevicesRequest(
    filters: Iterable[zio.aws.braket.model.SearchDevicesFilter],
    maxResults: Optional[SearchDevicesRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.SearchDevicesRequest = {
    import SearchDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.SearchDevicesRequest
      .builder()
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        maxResults.map(value =>
          SearchDevicesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.braket.model.SearchDevicesRequest.ReadOnly =
    zio.aws.braket.model.SearchDevicesRequest.wrap(buildAwsValue())
}
object SearchDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.SearchDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.SearchDevicesRequest =
      zio.aws.braket.model.SearchDevicesRequest(
        filters.map { item =>
          item.asEditable
        },
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: List[zio.aws.braket.model.SearchDevicesFilter.ReadOnly]
    def maxResults: Optional[SearchDevicesRequestMaxResultsInteger]
    def nextToken: Optional[String]
    def getFilters: ZIO[Any, Nothing, List[
      zio.aws.braket.model.SearchDevicesFilter.ReadOnly
    ]] = ZIO.succeed(filters)
    def getMaxResults
        : ZIO[Any, AwsError, SearchDevicesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.SearchDevicesRequest
  ) extends zio.aws.braket.model.SearchDevicesRequest.ReadOnly {
    override val filters
        : List[zio.aws.braket.model.SearchDevicesFilter.ReadOnly] = impl
      .filters()
      .asScala
      .map { item =>
        zio.aws.braket.model.SearchDevicesFilter.wrap(item)
      }
      .toList
    override val maxResults: Optional[SearchDevicesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.braket.model.primitives
            .SearchDevicesRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.SearchDevicesRequest
  ): zio.aws.braket.model.SearchDevicesRequest.ReadOnly = new Wrapper(impl)
}
