package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.braket.model.primitives.S3Path
import scala.jdk.CollectionConverters.*
final case class ScriptModeConfig(
    compressionType: Optional[zio.aws.braket.model.CompressionType] =
      Optional.Absent,
    entryPoint: String,
    s3Uri: S3Path
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.ScriptModeConfig = {
    import ScriptModeConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.ScriptModeConfig
      .builder()
      .optionallyWith(compressionType.map(value => value.unwrap))(
        _.compressionType
      )
      .entryPoint(entryPoint: java.lang.String)
      .s3Uri(S3Path.unwrap(s3Uri): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.ScriptModeConfig.ReadOnly =
    zio.aws.braket.model.ScriptModeConfig.wrap(buildAwsValue())
}
object ScriptModeConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.ScriptModeConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.ScriptModeConfig = zio.aws.braket.model
      .ScriptModeConfig(compressionType.map(value => value), entryPoint, s3Uri)
    def compressionType: Optional[zio.aws.braket.model.CompressionType]
    def entryPoint: String
    def s3Uri: S3Path
    def getCompressionType
        : ZIO[Any, AwsError, zio.aws.braket.model.CompressionType] =
      AwsError.unwrapOptionField("compressionType", compressionType)
    def getEntryPoint: ZIO[Any, Nothing, String] = ZIO.succeed(entryPoint)
    def getS3Uri: ZIO[Any, Nothing, S3Path] = ZIO.succeed(s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.ScriptModeConfig
  ) extends zio.aws.braket.model.ScriptModeConfig.ReadOnly {
    override val compressionType
        : Optional[zio.aws.braket.model.CompressionType] = zio.aws.core.internal
      .optionalFromNullable(impl.compressionType())
      .map(value => zio.aws.braket.model.CompressionType.wrap(value))
    override val entryPoint: String = impl.entryPoint(): String
    override val s3Uri: S3Path =
      zio.aws.braket.model.primitives.S3Path(impl.s3Uri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.ScriptModeConfig
  ): zio.aws.braket.model.ScriptModeConfig.ReadOnly = new Wrapper(impl)
}
