package zio.aws.braket.model
import scala.jdk.CollectionConverters.*
sealed trait InstanceType {
  def unwrap: software.amazon.awssdk.services.braket.model.InstanceType
}
object InstanceType {
  def wrap(
      value: software.amazon.awssdk.services.braket.model.InstanceType
  ): zio.aws.braket.model.InstanceType = value match {
    case software.amazon.awssdk.services.braket.model.InstanceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_M4_XLARGE =>
      val r = `ml.m4.xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_M4_2_XLARGE =>
      val r = `ml.m4.2xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_M4_4_XLARGE =>
      val r = `ml.m4.4xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_M4_10_XLARGE =>
      val r = `ml.m4.10xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_M4_16_XLARGE =>
      val r = `ml.m4.16xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_G4_DN_XLARGE =>
      val r = `ml.g4dn.xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_G4_DN_2_XLARGE =>
      val r = `ml.g4dn.2xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_G4_DN_4_XLARGE =>
      val r = `ml.g4dn.4xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_G4_DN_8_XLARGE =>
      val r = `ml.g4dn.8xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_G4_DN_12_XLARGE =>
      val r = `ml.g4dn.12xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_G4_DN_16_XLARGE =>
      val r = `ml.g4dn.16xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_M5_LARGE =>
      val r = `ml.m5.large`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_M5_XLARGE =>
      val r = `ml.m5.xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_M5_2_XLARGE =>
      val r = `ml.m5.2xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_M5_4_XLARGE =>
      val r = `ml.m5.4xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_M5_12_XLARGE =>
      val r = `ml.m5.12xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_M5_24_XLARGE =>
      val r = `ml.m5.24xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_C4_XLARGE =>
      val r = `ml.c4.xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_C4_2_XLARGE =>
      val r = `ml.c4.2xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_C4_4_XLARGE =>
      val r = `ml.c4.4xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_C4_8_XLARGE =>
      val r = `ml.c4.8xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_P2_XLARGE =>
      val r = `ml.p2.xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_P2_8_XLARGE =>
      val r = `ml.p2.8xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_P2_16_XLARGE =>
      val r = `ml.p2.16xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_P3_2_XLARGE =>
      val r = `ml.p3.2xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_P3_8_XLARGE =>
      val r = `ml.p3.8xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_P3_16_XLARGE =>
      val r = `ml.p3.16xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_P3_DN_24_XLARGE =>
      val r = `ml.p3dn.24xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_P4_D_24_XLARGE =>
      val r = `ml.p4d.24xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_XLARGE =>
      val r = `ml.c5.xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_2_XLARGE =>
      val r = `ml.c5.2xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_4_XLARGE =>
      val r = `ml.c5.4xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_9_XLARGE =>
      val r = `ml.c5.9xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_18_XLARGE =>
      val r = `ml.c5.18xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_N_XLARGE =>
      val r = `ml.c5n.xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_N_2_XLARGE =>
      val r = `ml.c5n.2xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_N_4_XLARGE =>
      val r = `ml.c5n.4xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_N_9_XLARGE =>
      val r = `ml.c5n.9xlarge`
      r
    case software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_N_18_XLARGE =>
      val r = `ml.c5n.18xlarge`
      r
  }
  case object unknownToSdkVersion extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `ml.m4.xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_M4_XLARGE
  }
  case object `ml.m4.2xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_M4_2_XLARGE
  }
  case object `ml.m4.4xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_M4_4_XLARGE
  }
  case object `ml.m4.10xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_M4_10_XLARGE
  }
  case object `ml.m4.16xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_M4_16_XLARGE
  }
  case object `ml.g4dn.xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_G4_DN_XLARGE
  }
  case object `ml.g4dn.2xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_G4_DN_2_XLARGE
  }
  case object `ml.g4dn.4xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_G4_DN_4_XLARGE
  }
  case object `ml.g4dn.8xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_G4_DN_8_XLARGE
  }
  case object `ml.g4dn.12xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_G4_DN_12_XLARGE
  }
  case object `ml.g4dn.16xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_G4_DN_16_XLARGE
  }
  case object `ml.m5.large` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_M5_LARGE
  }
  case object `ml.m5.xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_M5_XLARGE
  }
  case object `ml.m5.2xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_M5_2_XLARGE
  }
  case object `ml.m5.4xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_M5_4_XLARGE
  }
  case object `ml.m5.12xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_M5_12_XLARGE
  }
  case object `ml.m5.24xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_M5_24_XLARGE
  }
  case object `ml.c4.xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_C4_XLARGE
  }
  case object `ml.c4.2xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_C4_2_XLARGE
  }
  case object `ml.c4.4xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_C4_4_XLARGE
  }
  case object `ml.c4.8xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_C4_8_XLARGE
  }
  case object `ml.p2.xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_P2_XLARGE
  }
  case object `ml.p2.8xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_P2_8_XLARGE
  }
  case object `ml.p2.16xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_P2_16_XLARGE
  }
  case object `ml.p3.2xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_P3_2_XLARGE
  }
  case object `ml.p3.8xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_P3_8_XLARGE
  }
  case object `ml.p3.16xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_P3_16_XLARGE
  }
  case object `ml.p3dn.24xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_P3_DN_24_XLARGE
  }
  case object `ml.p4d.24xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_P4_D_24_XLARGE
  }
  case object `ml.c5.xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_XLARGE
  }
  case object `ml.c5.2xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_2_XLARGE
  }
  case object `ml.c5.4xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_4_XLARGE
  }
  case object `ml.c5.9xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_9_XLARGE
  }
  case object `ml.c5.18xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_18_XLARGE
  }
  case object `ml.c5n.xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_N_XLARGE
  }
  case object `ml.c5n.2xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_N_2_XLARGE
  }
  case object `ml.c5n.4xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_N_4_XLARGE
  }
  case object `ml.c5n.9xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_N_9_XLARGE
  }
  case object `ml.c5n.18xlarge` extends zio.aws.braket.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.InstanceType =
      software.amazon.awssdk.services.braket.model.InstanceType.ML_C5_N_18_XLARGE
  }
}
