package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.braket.model.primitives.DeviceArn
import scala.jdk.CollectionConverters.*
final case class GetDeviceRequest(deviceArn: DeviceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.GetDeviceRequest = {
    import GetDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.GetDeviceRequest
      .builder()
      .deviceArn(DeviceArn.unwrap(deviceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.GetDeviceRequest.ReadOnly =
    zio.aws.braket.model.GetDeviceRequest.wrap(buildAwsValue())
}
object GetDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.GetDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.GetDeviceRequest =
      zio.aws.braket.model.GetDeviceRequest(deviceArn)
    def deviceArn: DeviceArn
    def getDeviceArn: ZIO[Any, Nothing, DeviceArn] = ZIO.succeed(deviceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.GetDeviceRequest
  ) extends zio.aws.braket.model.GetDeviceRequest.ReadOnly {
    override val deviceArn: DeviceArn =
      zio.aws.braket.model.primitives.DeviceArn(impl.deviceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.GetDeviceRequest
  ): zio.aws.braket.model.GetDeviceRequest.ReadOnly = new Wrapper(impl)
}
