package zio.aws.braket.model
import scala.jdk.CollectionConverters.*
sealed trait CompressionType {
  def unwrap: software.amazon.awssdk.services.braket.model.CompressionType
}
object CompressionType {
  def wrap(
      value: software.amazon.awssdk.services.braket.model.CompressionType
  ): zio.aws.braket.model.CompressionType = value match {
    case software.amazon.awssdk.services.braket.model.CompressionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.braket.model.CompressionType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.braket.model.CompressionType.GZIP =>
      val r = GZIP
      r
  }
  case object unknownToSdkVersion extends zio.aws.braket.model.CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.CompressionType =
      software.amazon.awssdk.services.braket.model.CompressionType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.braket.model.CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.CompressionType =
      software.amazon.awssdk.services.braket.model.CompressionType.NONE
  }
  case object GZIP extends zio.aws.braket.model.CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.CompressionType =
      software.amazon.awssdk.services.braket.model.CompressionType.GZIP
  }
}
