package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.braket.model.primitives.JobArn
import scala.jdk.CollectionConverters.*
final case class CancelJobRequest(jobArn: JobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.CancelJobRequest = {
    import CancelJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.CancelJobRequest
      .builder()
      .jobArn(JobArn.unwrap(jobArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.CancelJobRequest.ReadOnly =
    zio.aws.braket.model.CancelJobRequest.wrap(buildAwsValue())
}
object CancelJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.CancelJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.CancelJobRequest =
      zio.aws.braket.model.CancelJobRequest(jobArn)
    def jobArn: JobArn
    def getJobArn: ZIO[Any, Nothing, JobArn] = ZIO.succeed(jobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.CancelJobRequest
  ) extends zio.aws.braket.model.CancelJobRequest.ReadOnly {
    override val jobArn: JobArn =
      zio.aws.braket.model.primitives.JobArn(impl.jobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.CancelJobRequest
  ): zio.aws.braket.model.CancelJobRequest.ReadOnly = new Wrapper(impl)
}
