package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.braket.model.primitives.QuantumTaskArn
import scala.jdk.CollectionConverters.*
final case class CancelQuantumTaskResponse(
    cancellationStatus: zio.aws.braket.model.CancellationStatus,
    quantumTaskArn: QuantumTaskArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.CancelQuantumTaskResponse = {
    import CancelQuantumTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.CancelQuantumTaskResponse
      .builder()
      .cancellationStatus(cancellationStatus.unwrap)
      .quantumTaskArn(QuantumTaskArn.unwrap(quantumTaskArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.CancelQuantumTaskResponse.ReadOnly =
    zio.aws.braket.model.CancelQuantumTaskResponse.wrap(buildAwsValue())
}
object CancelQuantumTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.CancelQuantumTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.CancelQuantumTaskResponse =
      zio.aws.braket.model
        .CancelQuantumTaskResponse(cancellationStatus, quantumTaskArn)
    def cancellationStatus: zio.aws.braket.model.CancellationStatus
    def quantumTaskArn: QuantumTaskArn
    def getCancellationStatus
        : ZIO[Any, Nothing, zio.aws.braket.model.CancellationStatus] =
      ZIO.succeed(cancellationStatus)
    def getQuantumTaskArn: ZIO[Any, Nothing, QuantumTaskArn] =
      ZIO.succeed(quantumTaskArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.CancelQuantumTaskResponse
  ) extends zio.aws.braket.model.CancelQuantumTaskResponse.ReadOnly {
    override val cancellationStatus: zio.aws.braket.model.CancellationStatus =
      zio.aws.braket.model.CancellationStatus.wrap(impl.cancellationStatus())
    override val quantumTaskArn: QuantumTaskArn =
      zio.aws.braket.model.primitives.QuantumTaskArn(impl.quantumTaskArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.CancelQuantumTaskResponse
  ): zio.aws.braket.model.CancelQuantumTaskResponse.ReadOnly = new Wrapper(impl)
}
