package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.braket.model.primitives.{String256, String64}
import scala.jdk.CollectionConverters.*
final case class SearchQuantumTasksFilter(
    name: String64,
    operator: zio.aws.braket.model.SearchQuantumTasksFilterOperator,
    values: Iterable[String256]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.SearchQuantumTasksFilter = {
    import SearchQuantumTasksFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.SearchQuantumTasksFilter
      .builder()
      .name(String64.unwrap(name): java.lang.String)
      .operator(operator.unwrap)
      .values(values.map { item =>
        String256.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.SearchQuantumTasksFilter.ReadOnly =
    zio.aws.braket.model.SearchQuantumTasksFilter.wrap(buildAwsValue())
}
object SearchQuantumTasksFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.SearchQuantumTasksFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.SearchQuantumTasksFilter =
      zio.aws.braket.model.SearchQuantumTasksFilter(name, operator, values)
    def name: String64
    def operator: zio.aws.braket.model.SearchQuantumTasksFilterOperator
    def values: List[String256]
    def getName: ZIO[Any, Nothing, String64] = ZIO.succeed(name)
    def getOperator: ZIO[
      Any,
      Nothing,
      zio.aws.braket.model.SearchQuantumTasksFilterOperator
    ] = ZIO.succeed(operator)
    def getValues: ZIO[Any, Nothing, List[String256]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.SearchQuantumTasksFilter
  ) extends zio.aws.braket.model.SearchQuantumTasksFilter.ReadOnly {
    override val name: String64 =
      zio.aws.braket.model.primitives.String64(impl.name())
    override val operator
        : zio.aws.braket.model.SearchQuantumTasksFilterOperator =
      zio.aws.braket.model.SearchQuantumTasksFilterOperator
        .wrap(impl.operator())
    override val values: List[String256] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.braket.model.primitives.String256(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.SearchQuantumTasksFilter
  ): zio.aws.braket.model.SearchQuantumTasksFilter.ReadOnly = new Wrapper(impl)
}
