package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.braket.model.primitives.String256
import scala.jdk.CollectionConverters.*
final case class DeviceConfig(device: String256) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.DeviceConfig = {
    import DeviceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.DeviceConfig
      .builder()
      .device(String256.unwrap(device): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.DeviceConfig.ReadOnly =
    zio.aws.braket.model.DeviceConfig.wrap(buildAwsValue())
}
object DeviceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.DeviceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.DeviceConfig =
      zio.aws.braket.model.DeviceConfig(device)
    def device: String256
    def getDevice: ZIO[Any, Nothing, String256] = ZIO.succeed(device)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.DeviceConfig
  ) extends zio.aws.braket.model.DeviceConfig.ReadOnly {
    override val device: String256 =
      zio.aws.braket.model.primitives.String256(impl.device())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.DeviceConfig
  ): zio.aws.braket.model.DeviceConfig.ReadOnly = new Wrapper(impl)
}
