package zio.aws.braket.model
import zio.aws.braket.model.primitives.SearchQuantumTasksRequestMaxResultsInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchQuantumTasksRequest(
    filters: Iterable[zio.aws.braket.model.SearchQuantumTasksFilter],
    maxResults: Optional[SearchQuantumTasksRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest = {
    import SearchQuantumTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest
      .builder()
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        maxResults.map(value =>
          SearchQuantumTasksRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.braket.model.SearchQuantumTasksRequest.ReadOnly =
    zio.aws.braket.model.SearchQuantumTasksRequest.wrap(buildAwsValue())
}
object SearchQuantumTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.SearchQuantumTasksRequest =
      zio.aws.braket.model.SearchQuantumTasksRequest(
        filters.map { item =>
          item.asEditable
        },
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: List[zio.aws.braket.model.SearchQuantumTasksFilter.ReadOnly]
    def maxResults: Optional[SearchQuantumTasksRequestMaxResultsInteger]
    def nextToken: Optional[String]
    def getFilters: ZIO[Any, Nothing, List[
      zio.aws.braket.model.SearchQuantumTasksFilter.ReadOnly
    ]] = ZIO.succeed(filters)
    def getMaxResults
        : ZIO[Any, AwsError, SearchQuantumTasksRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest
  ) extends zio.aws.braket.model.SearchQuantumTasksRequest.ReadOnly {
    override val filters
        : List[zio.aws.braket.model.SearchQuantumTasksFilter.ReadOnly] = impl
      .filters()
      .asScala
      .map { item =>
        zio.aws.braket.model.SearchQuantumTasksFilter.wrap(item)
      }
      .toList
    override val maxResults
        : Optional[SearchQuantumTasksRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.braket.model.primitives
            .SearchQuantumTasksRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest
  ): zio.aws.braket.model.SearchQuantumTasksRequest.ReadOnly = new Wrapper(impl)
}
