package zio.aws.braket.model
import zio.aws.braket.model.primitives.{
  QuantumTaskArn,
  DeviceArn,
  SyntheticTimestamp_date_time
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class QuantumTaskSummary(
    createdAt: SyntheticTimestamp_date_time,
    deviceArn: DeviceArn,
    endedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    outputS3Bucket: String,
    outputS3Directory: String,
    quantumTaskArn: QuantumTaskArn,
    shots: Long,
    status: zio.aws.braket.model.QuantumTaskStatus,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.QuantumTaskSummary = {
    import QuantumTaskSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.QuantumTaskSummary
      .builder()
      .createdAt(SyntheticTimestamp_date_time.unwrap(createdAt): Instant)
      .deviceArn(DeviceArn.unwrap(deviceArn): java.lang.String)
      .optionallyWith(
        endedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.endedAt)
      .outputS3Bucket(outputS3Bucket: java.lang.String)
      .outputS3Directory(outputS3Directory: java.lang.String)
      .quantumTaskArn(QuantumTaskArn.unwrap(quantumTaskArn): java.lang.String)
      .shots(shots: java.lang.Long)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.QuantumTaskSummary.ReadOnly =
    zio.aws.braket.model.QuantumTaskSummary.wrap(buildAwsValue())
}
object QuantumTaskSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.QuantumTaskSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.QuantumTaskSummary =
      zio.aws.braket.model.QuantumTaskSummary(
        createdAt,
        deviceArn,
        endedAt.map(value => value),
        outputS3Bucket,
        outputS3Directory,
        quantumTaskArn,
        shots,
        status,
        tags.map(value => value)
      )
    def createdAt: SyntheticTimestamp_date_time
    def deviceArn: DeviceArn
    def endedAt: Optional[SyntheticTimestamp_date_time]
    def outputS3Bucket: String
    def outputS3Directory: String
    def quantumTaskArn: QuantumTaskArn
    def shots: Long
    def status: zio.aws.braket.model.QuantumTaskStatus
    def tags: Optional[Map[String, String]]
    def getCreatedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(createdAt)
    def getDeviceArn: ZIO[Any, Nothing, DeviceArn] = ZIO.succeed(deviceArn)
    def getEndedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("endedAt", endedAt)
    def getOutputS3Bucket: ZIO[Any, Nothing, String] =
      ZIO.succeed(outputS3Bucket)
    def getOutputS3Directory: ZIO[Any, Nothing, String] =
      ZIO.succeed(outputS3Directory)
    def getQuantumTaskArn: ZIO[Any, Nothing, QuantumTaskArn] =
      ZIO.succeed(quantumTaskArn)
    def getShots: ZIO[Any, Nothing, Long] = ZIO.succeed(shots)
    def getStatus: ZIO[Any, Nothing, zio.aws.braket.model.QuantumTaskStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.QuantumTaskSummary
  ) extends zio.aws.braket.model.QuantumTaskSummary.ReadOnly {
    override val createdAt: SyntheticTimestamp_date_time =
      zio.aws.braket.model.primitives
        .SyntheticTimestamp_date_time(impl.createdAt())
    override val deviceArn: DeviceArn =
      zio.aws.braket.model.primitives.DeviceArn(impl.deviceArn())
    override val endedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endedAt())
        .map(value =>
          zio.aws.braket.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val outputS3Bucket: String = impl.outputS3Bucket(): String
    override val outputS3Directory: String = impl.outputS3Directory(): String
    override val quantumTaskArn: QuantumTaskArn =
      zio.aws.braket.model.primitives.QuantumTaskArn(impl.quantumTaskArn())
    override val shots: Long = impl.shots(): Long
    override val status: zio.aws.braket.model.QuantumTaskStatus =
      zio.aws.braket.model.QuantumTaskStatus.wrap(impl.status())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.QuantumTaskSummary
  ): zio.aws.braket.model.QuantumTaskSummary.ReadOnly = new Wrapper(impl)
}
