package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.braket.model.primitives.JobArn
import scala.jdk.CollectionConverters.*
final case class GetJobRequest(jobArn: JobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.GetJobRequest = {
    import GetJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.GetJobRequest
      .builder()
      .jobArn(JobArn.unwrap(jobArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.GetJobRequest.ReadOnly =
    zio.aws.braket.model.GetJobRequest.wrap(buildAwsValue())
}
object GetJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.GetJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.GetJobRequest =
      zio.aws.braket.model.GetJobRequest(jobArn)
    def jobArn: JobArn
    def getJobArn: ZIO[Any, Nothing, JobArn] = ZIO.succeed(jobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.GetJobRequest
  ) extends zio.aws.braket.model.GetJobRequest.ReadOnly {
    override val jobArn: JobArn =
      zio.aws.braket.model.primitives.JobArn(impl.jobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.GetJobRequest
  ): zio.aws.braket.model.GetJobRequest.ReadOnly = new Wrapper(impl)
}
