package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.braket.model.primitives.{
  DeviceArn,
  CreateQuantumTaskRequestOutputS3KeyPrefixString,
  JobToken,
  CreateQuantumTaskRequestShotsLong,
  String64,
  CreateQuantumTaskRequestDeviceParametersString,
  CreateQuantumTaskRequestOutputS3BucketString,
  JsonValue
}
import scala.jdk.CollectionConverters.*
final case class CreateQuantumTaskRequest(
    action: JsonValue,
    clientToken: String64,
    deviceArn: DeviceArn,
    deviceParameters: Optional[CreateQuantumTaskRequestDeviceParametersString] =
      Optional.Absent,
    jobToken: Optional[JobToken] = Optional.Absent,
    outputS3Bucket: CreateQuantumTaskRequestOutputS3BucketString,
    outputS3KeyPrefix: CreateQuantumTaskRequestOutputS3KeyPrefixString,
    shots: CreateQuantumTaskRequestShotsLong,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.CreateQuantumTaskRequest = {
    import CreateQuantumTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.CreateQuantumTaskRequest
      .builder()
      .action(JsonValue.unwrap(action): java.lang.String)
      .clientToken(String64.unwrap(clientToken): java.lang.String)
      .deviceArn(DeviceArn.unwrap(deviceArn): java.lang.String)
      .optionallyWith(
        deviceParameters.map(value =>
          CreateQuantumTaskRequestDeviceParametersString.unwrap(
            value
          ): java.lang.String
        )
      )(_.deviceParameters)
      .optionallyWith(
        jobToken.map(value => JobToken.unwrap(value): java.lang.String)
      )(_.jobToken)
      .outputS3Bucket(
        CreateQuantumTaskRequestOutputS3BucketString.unwrap(
          outputS3Bucket
        ): java.lang.String
      )
      .outputS3KeyPrefix(
        CreateQuantumTaskRequestOutputS3KeyPrefixString.unwrap(
          outputS3KeyPrefix
        ): java.lang.String
      )
      .shots(CreateQuantumTaskRequestShotsLong.unwrap(shots): java.lang.Long)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.CreateQuantumTaskRequest.ReadOnly =
    zio.aws.braket.model.CreateQuantumTaskRequest.wrap(buildAwsValue())
}
object CreateQuantumTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.CreateQuantumTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.CreateQuantumTaskRequest =
      zio.aws.braket.model.CreateQuantumTaskRequest(
        action,
        clientToken,
        deviceArn,
        deviceParameters.map(value => value),
        jobToken.map(value => value),
        outputS3Bucket,
        outputS3KeyPrefix,
        shots,
        tags.map(value => value)
      )
    def action: JsonValue
    def clientToken: String64
    def deviceArn: DeviceArn
    def deviceParameters
        : Optional[CreateQuantumTaskRequestDeviceParametersString]
    def jobToken: Optional[JobToken]
    def outputS3Bucket: CreateQuantumTaskRequestOutputS3BucketString
    def outputS3KeyPrefix: CreateQuantumTaskRequestOutputS3KeyPrefixString
    def shots: CreateQuantumTaskRequestShotsLong
    def tags: Optional[Map[String, String]]
    def getAction: ZIO[Any, Nothing, JsonValue] = ZIO.succeed(action)
    def getClientToken: ZIO[Any, Nothing, String64] = ZIO.succeed(clientToken)
    def getDeviceArn: ZIO[Any, Nothing, DeviceArn] = ZIO.succeed(deviceArn)
    def getDeviceParameters
        : ZIO[Any, AwsError, CreateQuantumTaskRequestDeviceParametersString] =
      AwsError.unwrapOptionField("deviceParameters", deviceParameters)
    def getJobToken: ZIO[Any, AwsError, JobToken] =
      AwsError.unwrapOptionField("jobToken", jobToken)
    def getOutputS3Bucket
        : ZIO[Any, Nothing, CreateQuantumTaskRequestOutputS3BucketString] =
      ZIO.succeed(outputS3Bucket)
    def getOutputS3KeyPrefix
        : ZIO[Any, Nothing, CreateQuantumTaskRequestOutputS3KeyPrefixString] =
      ZIO.succeed(outputS3KeyPrefix)
    def getShots: ZIO[Any, Nothing, CreateQuantumTaskRequestShotsLong] =
      ZIO.succeed(shots)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.CreateQuantumTaskRequest
  ) extends zio.aws.braket.model.CreateQuantumTaskRequest.ReadOnly {
    override val action: JsonValue =
      zio.aws.braket.model.primitives.JsonValue(impl.action())
    override val clientToken: String64 =
      zio.aws.braket.model.primitives.String64(impl.clientToken())
    override val deviceArn: DeviceArn =
      zio.aws.braket.model.primitives.DeviceArn(impl.deviceArn())
    override val deviceParameters
        : Optional[CreateQuantumTaskRequestDeviceParametersString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceParameters())
        .map(value =>
          zio.aws.braket.model.primitives
            .CreateQuantumTaskRequestDeviceParametersString(value)
        )
    override val jobToken: Optional[JobToken] = zio.aws.core.internal
      .optionalFromNullable(impl.jobToken())
      .map(value => zio.aws.braket.model.primitives.JobToken(value))
    override val outputS3Bucket: CreateQuantumTaskRequestOutputS3BucketString =
      zio.aws.braket.model.primitives
        .CreateQuantumTaskRequestOutputS3BucketString(impl.outputS3Bucket())
    override val outputS3KeyPrefix
        : CreateQuantumTaskRequestOutputS3KeyPrefixString =
      zio.aws.braket.model.primitives
        .CreateQuantumTaskRequestOutputS3KeyPrefixString(
          impl.outputS3KeyPrefix()
        )
    override val shots: CreateQuantumTaskRequestShotsLong =
      zio.aws.braket.model.primitives
        .CreateQuantumTaskRequestShotsLong(impl.shots())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.CreateQuantumTaskRequest
  ): zio.aws.braket.model.CreateQuantumTaskRequest.ReadOnly = new Wrapper(impl)
}
