package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SearchJobsResponse(
    jobs: Iterable[zio.aws.braket.model.JobSummary],
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.SearchJobsResponse = {
    import SearchJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.SearchJobsResponse
      .builder()
      .jobs(jobs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.braket.model.SearchJobsResponse.ReadOnly =
    zio.aws.braket.model.SearchJobsResponse.wrap(buildAwsValue())
}
object SearchJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.SearchJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.SearchJobsResponse =
      zio.aws.braket.model.SearchJobsResponse(
        jobs.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def jobs: List[zio.aws.braket.model.JobSummary.ReadOnly]
    def nextToken: Option[String]
    def getJobs
        : ZIO[Any, Nothing, List[zio.aws.braket.model.JobSummary.ReadOnly]] =
      ZIO.succeed(jobs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.SearchJobsResponse
  ) extends zio.aws.braket.model.SearchJobsResponse.ReadOnly {
    override val jobs: List[zio.aws.braket.model.JobSummary.ReadOnly] = impl
      .jobs()
      .asScala
      .map { item =>
        zio.aws.braket.model.JobSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.SearchJobsResponse
  ): zio.aws.braket.model.SearchJobsResponse.ReadOnly = new Wrapper(impl)
}
