package zio.aws.braket.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.braket.model.primitives.SearchJobsRequestMaxResultsInteger
import scala.jdk.CollectionConverters.*
final case class SearchJobsRequest(
    filters: Iterable[zio.aws.braket.model.SearchJobsFilter],
    maxResults: Option[SearchJobsRequestMaxResultsInteger] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.SearchJobsRequest = {
    import SearchJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.SearchJobsRequest
      .builder()
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        maxResults.map(value =>
          SearchJobsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.braket.model.SearchJobsRequest.ReadOnly =
    zio.aws.braket.model.SearchJobsRequest.wrap(buildAwsValue())
}
object SearchJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.SearchJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.SearchJobsRequest =
      zio.aws.braket.model.SearchJobsRequest(
        filters.map { item =>
          item.asEditable
        },
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: List[zio.aws.braket.model.SearchJobsFilter.ReadOnly]
    def maxResults: Option[SearchJobsRequestMaxResultsInteger]
    def nextToken: Option[String]
    def getFilters: ZIO[Any, Nothing, List[
      zio.aws.braket.model.SearchJobsFilter.ReadOnly
    ]] = ZIO.succeed(filters)
    def getMaxResults: ZIO[Any, AwsError, SearchJobsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.SearchJobsRequest
  ) extends zio.aws.braket.model.SearchJobsRequest.ReadOnly {
    override val filters: List[zio.aws.braket.model.SearchJobsFilter.ReadOnly] =
      impl
        .filters()
        .asScala
        .map { item =>
          zio.aws.braket.model.SearchJobsFilter.wrap(item)
        }
        .toList
    override val maxResults: Option[SearchJobsRequestMaxResultsInteger] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.braket.model.primitives
          .SearchJobsRequestMaxResultsInteger(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.SearchJobsRequest
  ): zio.aws.braket.model.SearchJobsRequest.ReadOnly = new Wrapper(impl)
}
