package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SearchDevicesResponse(
    devices: Iterable[zio.aws.braket.model.DeviceSummary],
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.SearchDevicesResponse = {
    import SearchDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.SearchDevicesResponse
      .builder()
      .devices(devices.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.braket.model.SearchDevicesResponse.ReadOnly =
    zio.aws.braket.model.SearchDevicesResponse.wrap(buildAwsValue())
}
object SearchDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.SearchDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.SearchDevicesResponse =
      zio.aws.braket.model.SearchDevicesResponse(
        devices.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def devices: List[zio.aws.braket.model.DeviceSummary.ReadOnly]
    def nextToken: Option[String]
    def getDevices
        : ZIO[Any, Nothing, List[zio.aws.braket.model.DeviceSummary.ReadOnly]] =
      ZIO.succeed(devices)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.SearchDevicesResponse
  ) extends zio.aws.braket.model.SearchDevicesResponse.ReadOnly {
    override val devices: List[zio.aws.braket.model.DeviceSummary.ReadOnly] =
      impl
        .devices()
        .asScala
        .map { item =>
          zio.aws.braket.model.DeviceSummary.wrap(item)
        }
        .toList
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.SearchDevicesResponse
  ): zio.aws.braket.model.SearchDevicesResponse.ReadOnly = new Wrapper(impl)
}
