package zio.aws.braket.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.braket.model.primitives.SearchDevicesRequestMaxResultsInteger
import scala.jdk.CollectionConverters.*
final case class SearchDevicesRequest(
    filters: Iterable[zio.aws.braket.model.SearchDevicesFilter],
    maxResults: Option[SearchDevicesRequestMaxResultsInteger] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.SearchDevicesRequest = {
    import SearchDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.SearchDevicesRequest
      .builder()
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        maxResults.map(value =>
          SearchDevicesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.braket.model.SearchDevicesRequest.ReadOnly =
    zio.aws.braket.model.SearchDevicesRequest.wrap(buildAwsValue())
}
object SearchDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.SearchDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.SearchDevicesRequest =
      zio.aws.braket.model.SearchDevicesRequest(
        filters.map { item =>
          item.asEditable
        },
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: List[zio.aws.braket.model.SearchDevicesFilter.ReadOnly]
    def maxResults: Option[SearchDevicesRequestMaxResultsInteger]
    def nextToken: Option[String]
    def getFilters: ZIO[Any, Nothing, List[
      zio.aws.braket.model.SearchDevicesFilter.ReadOnly
    ]] = ZIO.succeed(filters)
    def getMaxResults
        : ZIO[Any, AwsError, SearchDevicesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.SearchDevicesRequest
  ) extends zio.aws.braket.model.SearchDevicesRequest.ReadOnly {
    override val filters
        : List[zio.aws.braket.model.SearchDevicesFilter.ReadOnly] = impl
      .filters()
      .asScala
      .map { item =>
        zio.aws.braket.model.SearchDevicesFilter.wrap(item)
      }
      .toList
    override val maxResults: Option[SearchDevicesRequestMaxResultsInteger] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.braket.model.primitives
            .SearchDevicesRequestMaxResultsInteger(value)
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.SearchDevicesRequest
  ): zio.aws.braket.model.SearchDevicesRequest.ReadOnly = new Wrapper(impl)
}
