package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.braket.model.primitives.{
  JobArn,
  String256,
  SyntheticTimestamp_date_time
}
import scala.jdk.CollectionConverters.*
final case class JobSummary(
    createdAt: SyntheticTimestamp_date_time,
    device: String256,
    endedAt: Option[SyntheticTimestamp_date_time] = None,
    jobArn: JobArn,
    jobName: String,
    startedAt: Option[SyntheticTimestamp_date_time] = None,
    status: zio.aws.braket.model.JobPrimaryStatus,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.JobSummary = {
    import JobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.JobSummary
      .builder()
      .createdAt(SyntheticTimestamp_date_time.unwrap(createdAt): Instant)
      .device(String256.unwrap(device): java.lang.String)
      .optionallyWith(
        endedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.endedAt)
      .jobArn(JobArn.unwrap(jobArn): java.lang.String)
      .jobName(jobName: java.lang.String)
      .optionallyWith(
        startedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.startedAt)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.JobSummary.ReadOnly =
    zio.aws.braket.model.JobSummary.wrap(buildAwsValue())
}
object JobSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.braket.model.JobSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.JobSummary =
      zio.aws.braket.model.JobSummary(
        createdAt,
        device,
        endedAt.map(value => value),
        jobArn,
        jobName,
        startedAt.map(value => value),
        status,
        tags.map(value => value)
      )
    def createdAt: SyntheticTimestamp_date_time
    def device: String256
    def endedAt: Option[SyntheticTimestamp_date_time]
    def jobArn: JobArn
    def jobName: String
    def startedAt: Option[SyntheticTimestamp_date_time]
    def status: zio.aws.braket.model.JobPrimaryStatus
    def tags: Option[Map[String, String]]
    def getCreatedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(createdAt)
    def getDevice: ZIO[Any, Nothing, String256] = ZIO.succeed(device)
    def getEndedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("endedAt", endedAt)
    def getJobArn: ZIO[Any, Nothing, JobArn] = ZIO.succeed(jobArn)
    def getJobName: ZIO[Any, Nothing, String] = ZIO.succeed(jobName)
    def getStartedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getStatus: ZIO[Any, Nothing, zio.aws.braket.model.JobPrimaryStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.JobSummary
  ) extends zio.aws.braket.model.JobSummary.ReadOnly {
    override val createdAt: SyntheticTimestamp_date_time =
      zio.aws.braket.model.primitives
        .SyntheticTimestamp_date_time(impl.createdAt())
    override val device: String256 =
      zio.aws.braket.model.primitives.String256(impl.device())
    override val endedAt: Option[SyntheticTimestamp_date_time] = scala
      .Option(impl.endedAt())
      .map(value =>
        zio.aws.braket.model.primitives.SyntheticTimestamp_date_time(value)
      )
    override val jobArn: JobArn =
      zio.aws.braket.model.primitives.JobArn(impl.jobArn())
    override val jobName: String = impl.jobName(): String
    override val startedAt: Option[SyntheticTimestamp_date_time] = scala
      .Option(impl.startedAt())
      .map(value =>
        zio.aws.braket.model.primitives.SyntheticTimestamp_date_time(value)
      )
    override val status: zio.aws.braket.model.JobPrimaryStatus =
      zio.aws.braket.model.JobPrimaryStatus.wrap(impl.status())
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.JobSummary
  ): zio.aws.braket.model.JobSummary.ReadOnly = new Wrapper(impl)
}
