package zio.aws.braket.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.braket.model.primitives.JobStoppingConditionMaxRuntimeInSecondsInteger
import scala.jdk.CollectionConverters.*
final case class JobStoppingCondition(
    maxRuntimeInSeconds: Option[
      JobStoppingConditionMaxRuntimeInSecondsInteger
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.JobStoppingCondition = {
    import JobStoppingCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.JobStoppingCondition
      .builder()
      .optionallyWith(
        maxRuntimeInSeconds.map(value =>
          JobStoppingConditionMaxRuntimeInSecondsInteger.unwrap(value): Integer
        )
      )(_.maxRuntimeInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.JobStoppingCondition.ReadOnly =
    zio.aws.braket.model.JobStoppingCondition.wrap(buildAwsValue())
}
object JobStoppingCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.JobStoppingCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.JobStoppingCondition =
      zio.aws.braket.model
        .JobStoppingCondition(maxRuntimeInSeconds.map(value => value))
    def maxRuntimeInSeconds
        : Option[JobStoppingConditionMaxRuntimeInSecondsInteger]
    def getMaxRuntimeInSeconds
        : ZIO[Any, AwsError, JobStoppingConditionMaxRuntimeInSecondsInteger] =
      AwsError.unwrapOptionField("maxRuntimeInSeconds", maxRuntimeInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.JobStoppingCondition
  ) extends zio.aws.braket.model.JobStoppingCondition.ReadOnly {
    override val maxRuntimeInSeconds
        : Option[JobStoppingConditionMaxRuntimeInSecondsInteger] = scala
      .Option(impl.maxRuntimeInSeconds())
      .map(value =>
        zio.aws.braket.model.primitives
          .JobStoppingConditionMaxRuntimeInSecondsInteger(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.JobStoppingCondition
  ): zio.aws.braket.model.JobStoppingCondition.ReadOnly = new Wrapper(impl)
}
