package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.braket.model.primitives.{
  SyntheticTimestamp_date_time,
  JobEventDetailsMessageString
}
import scala.jdk.CollectionConverters.*
final case class JobEventDetails(
    eventType: Option[zio.aws.braket.model.JobEventType] = None,
    message: Option[JobEventDetailsMessageString] = None,
    timeOfEvent: Option[SyntheticTimestamp_date_time] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.JobEventDetails = {
    import JobEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.JobEventDetails
      .builder()
      .optionallyWith(eventType.map(value => value.unwrap))(_.eventType)
      .optionallyWith(
        message.map(value =>
          JobEventDetailsMessageString.unwrap(value): java.lang.String
        )
      )(_.message)
      .optionallyWith(
        timeOfEvent.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.timeOfEvent)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.JobEventDetails.ReadOnly =
    zio.aws.braket.model.JobEventDetails.wrap(buildAwsValue())
}
object JobEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.JobEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.JobEventDetails =
      zio.aws.braket.model.JobEventDetails(
        eventType.map(value => value),
        message.map(value => value),
        timeOfEvent.map(value => value)
      )
    def eventType: Option[zio.aws.braket.model.JobEventType]
    def message: Option[JobEventDetailsMessageString]
    def timeOfEvent: Option[SyntheticTimestamp_date_time]
    def getEventType: ZIO[Any, AwsError, zio.aws.braket.model.JobEventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getMessage: ZIO[Any, AwsError, JobEventDetailsMessageString] =
      AwsError.unwrapOptionField("message", message)
    def getTimeOfEvent: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("timeOfEvent", timeOfEvent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.JobEventDetails
  ) extends zio.aws.braket.model.JobEventDetails.ReadOnly {
    override val eventType: Option[zio.aws.braket.model.JobEventType] = scala
      .Option(impl.eventType())
      .map(value => zio.aws.braket.model.JobEventType.wrap(value))
    override val message: Option[JobEventDetailsMessageString] = scala
      .Option(impl.message())
      .map(value =>
        zio.aws.braket.model.primitives.JobEventDetailsMessageString(value)
      )
    override val timeOfEvent: Option[SyntheticTimestamp_date_time] = scala
      .Option(impl.timeOfEvent())
      .map(value =>
        zio.aws.braket.model.primitives.SyntheticTimestamp_date_time(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.JobEventDetails
  ): zio.aws.braket.model.JobEventDetails.ReadOnly = new Wrapper(impl)
}
