package zio.aws.braket.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.braket.model.primitives.InstanceConfigVolumeSizeInGbInteger
import scala.jdk.CollectionConverters.*
final case class InstanceConfig(
    instanceType: zio.aws.braket.model.InstanceType,
    volumeSizeInGb: InstanceConfigVolumeSizeInGbInteger
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.InstanceConfig = {
    import InstanceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.InstanceConfig
      .builder()
      .instanceType(instanceType.unwrap)
      .volumeSizeInGb(
        InstanceConfigVolumeSizeInGbInteger.unwrap(volumeSizeInGb): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.braket.model.InstanceConfig.ReadOnly =
    zio.aws.braket.model.InstanceConfig.wrap(buildAwsValue())
}
object InstanceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.InstanceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.InstanceConfig =
      zio.aws.braket.model.InstanceConfig(instanceType, volumeSizeInGb)
    def instanceType: zio.aws.braket.model.InstanceType
    def volumeSizeInGb: InstanceConfigVolumeSizeInGbInteger
    def getInstanceType: ZIO[Any, Nothing, zio.aws.braket.model.InstanceType] =
      ZIO.succeed(instanceType)
    def getVolumeSizeInGb
        : ZIO[Any, Nothing, InstanceConfigVolumeSizeInGbInteger] =
      ZIO.succeed(volumeSizeInGb)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.InstanceConfig
  ) extends zio.aws.braket.model.InstanceConfig.ReadOnly {
    override val instanceType: zio.aws.braket.model.InstanceType =
      zio.aws.braket.model.InstanceType.wrap(impl.instanceType())
    override val volumeSizeInGb: InstanceConfigVolumeSizeInGbInteger =
      zio.aws.braket.model.primitives
        .InstanceConfigVolumeSizeInGbInteger(impl.volumeSizeInGb())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.InstanceConfig
  ): zio.aws.braket.model.InstanceConfig.ReadOnly = new Wrapper(impl)
}
