package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.braket.model.primitives.{
  String256,
  InputFileConfigChannelNameString
}
import scala.jdk.CollectionConverters.*
final case class InputFileConfig(
    channelName: InputFileConfigChannelNameString,
    contentType: Option[String256] = None,
    dataSource: zio.aws.braket.model.DataSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.InputFileConfig = {
    import InputFileConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.InputFileConfig
      .builder()
      .channelName(
        InputFileConfigChannelNameString.unwrap(channelName): java.lang.String
      )
      .optionallyWith(
        contentType.map(value => String256.unwrap(value): java.lang.String)
      )(_.contentType)
      .dataSource(dataSource.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.braket.model.InputFileConfig.ReadOnly =
    zio.aws.braket.model.InputFileConfig.wrap(buildAwsValue())
}
object InputFileConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.InputFileConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.InputFileConfig =
      zio.aws.braket.model.InputFileConfig(
        channelName,
        contentType.map(value => value),
        dataSource.asEditable
      )
    def channelName: InputFileConfigChannelNameString
    def contentType: Option[String256]
    def dataSource: zio.aws.braket.model.DataSource.ReadOnly
    def getChannelName: ZIO[Any, Nothing, InputFileConfigChannelNameString] =
      ZIO.succeed(channelName)
    def getContentType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getDataSource
        : ZIO[Any, Nothing, zio.aws.braket.model.DataSource.ReadOnly] =
      ZIO.succeed(dataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.InputFileConfig
  ) extends zio.aws.braket.model.InputFileConfig.ReadOnly {
    override val channelName: InputFileConfigChannelNameString =
      zio.aws.braket.model.primitives
        .InputFileConfigChannelNameString(impl.channelName())
    override val contentType: Option[String256] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.braket.model.primitives.String256(value))
    override val dataSource: zio.aws.braket.model.DataSource.ReadOnly =
      zio.aws.braket.model.DataSource.wrap(impl.dataSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.InputFileConfig
  ): zio.aws.braket.model.InputFileConfig.ReadOnly = new Wrapper(impl)
}
