package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DataSource(s3DataSource: zio.aws.braket.model.S3DataSource) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.DataSource = {
    import DataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.DataSource
      .builder()
      .s3DataSource(s3DataSource.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.braket.model.DataSource.ReadOnly =
    zio.aws.braket.model.DataSource.wrap(buildAwsValue())
}
object DataSource {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.braket.model.DataSource] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.DataSource =
      zio.aws.braket.model.DataSource(s3DataSource.asEditable)
    def s3DataSource: zio.aws.braket.model.S3DataSource.ReadOnly
    def getS3DataSource
        : ZIO[Any, Nothing, zio.aws.braket.model.S3DataSource.ReadOnly] =
      ZIO.succeed(s3DataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.DataSource
  ) extends zio.aws.braket.model.DataSource.ReadOnly {
    override val s3DataSource: zio.aws.braket.model.S3DataSource.ReadOnly =
      zio.aws.braket.model.S3DataSource.wrap(impl.s3DataSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.DataSource
  ): zio.aws.braket.model.DataSource.ReadOnly = new Wrapper(impl)
}
