package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.braket.model.primitives.{
  HyperParametersValueString,
  RoleArn,
  CreateJobRequestJobNameString,
  String64,
  String256
}
import scala.jdk.CollectionConverters.*
final case class CreateJobRequest(
    algorithmSpecification: zio.aws.braket.model.AlgorithmSpecification,
    checkpointConfig: Option[zio.aws.braket.model.JobCheckpointConfig] = None,
    clientToken: String64,
    deviceConfig: zio.aws.braket.model.DeviceConfig,
    hyperParameters: Option[Map[String256, HyperParametersValueString]] = None,
    inputDataConfig: Option[Iterable[zio.aws.braket.model.InputFileConfig]] =
      None,
    instanceConfig: zio.aws.braket.model.InstanceConfig,
    jobName: CreateJobRequestJobNameString,
    outputDataConfig: zio.aws.braket.model.JobOutputDataConfig,
    roleArn: RoleArn,
    stoppingCondition: Option[zio.aws.braket.model.JobStoppingCondition] = None,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.CreateJobRequest = {
    import CreateJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.CreateJobRequest
      .builder()
      .algorithmSpecification(algorithmSpecification.buildAwsValue())
      .optionallyWith(checkpointConfig.map(value => value.buildAwsValue()))(
        _.checkpointConfig
      )
      .clientToken(String64.unwrap(clientToken): java.lang.String)
      .deviceConfig(deviceConfig.buildAwsValue())
      .optionallyWith(
        hyperParameters.map(value =>
          value
            .map({ case (key, value) =>
              (String256.unwrap(
                key
              ): java.lang.String) -> (HyperParametersValueString.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.hyperParameters)
      .optionallyWith(
        inputDataConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDataConfig)
      .instanceConfig(instanceConfig.buildAwsValue())
      .jobName(CreateJobRequestJobNameString.unwrap(jobName): java.lang.String)
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(stoppingCondition.map(value => value.buildAwsValue()))(
        _.stoppingCondition
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.CreateJobRequest.ReadOnly =
    zio.aws.braket.model.CreateJobRequest.wrap(buildAwsValue())
}
object CreateJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.CreateJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.CreateJobRequest =
      zio.aws.braket.model.CreateJobRequest(
        algorithmSpecification.asEditable,
        checkpointConfig.map(value => value.asEditable),
        clientToken,
        deviceConfig.asEditable,
        hyperParameters.map(value => value),
        inputDataConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceConfig.asEditable,
        jobName,
        outputDataConfig.asEditable,
        roleArn,
        stoppingCondition.map(value => value.asEditable),
        tags.map(value => value)
      )
    def algorithmSpecification
        : zio.aws.braket.model.AlgorithmSpecification.ReadOnly
    def checkpointConfig
        : Option[zio.aws.braket.model.JobCheckpointConfig.ReadOnly]
    def clientToken: String64
    def deviceConfig: zio.aws.braket.model.DeviceConfig.ReadOnly
    def hyperParameters: Option[Map[String256, HyperParametersValueString]]
    def inputDataConfig
        : Option[List[zio.aws.braket.model.InputFileConfig.ReadOnly]]
    def instanceConfig: zio.aws.braket.model.InstanceConfig.ReadOnly
    def jobName: CreateJobRequestJobNameString
    def outputDataConfig: zio.aws.braket.model.JobOutputDataConfig.ReadOnly
    def roleArn: RoleArn
    def stoppingCondition
        : Option[zio.aws.braket.model.JobStoppingCondition.ReadOnly]
    def tags: Option[Map[String, String]]
    def getAlgorithmSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.braket.model.AlgorithmSpecification.ReadOnly
    ] = ZIO.succeed(algorithmSpecification)
    def getCheckpointConfig: ZIO[
      Any,
      AwsError,
      zio.aws.braket.model.JobCheckpointConfig.ReadOnly
    ] = AwsError.unwrapOptionField("checkpointConfig", checkpointConfig)
    def getClientToken: ZIO[Any, Nothing, String64] = ZIO.succeed(clientToken)
    def getDeviceConfig
        : ZIO[Any, Nothing, zio.aws.braket.model.DeviceConfig.ReadOnly] =
      ZIO.succeed(deviceConfig)
    def getHyperParameters
        : ZIO[Any, AwsError, Map[String256, HyperParametersValueString]] =
      AwsError.unwrapOptionField("hyperParameters", hyperParameters)
    def getInputDataConfig: ZIO[Any, AwsError, List[
      zio.aws.braket.model.InputFileConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getInstanceConfig
        : ZIO[Any, Nothing, zio.aws.braket.model.InstanceConfig.ReadOnly] =
      ZIO.succeed(instanceConfig)
    def getJobName: ZIO[Any, Nothing, CreateJobRequestJobNameString] =
      ZIO.succeed(jobName)
    def getOutputDataConfig
        : ZIO[Any, Nothing, zio.aws.braket.model.JobOutputDataConfig.ReadOnly] =
      ZIO.succeed(outputDataConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStoppingCondition: ZIO[
      Any,
      AwsError,
      zio.aws.braket.model.JobStoppingCondition.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingCondition", stoppingCondition)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.CreateJobRequest
  ) extends zio.aws.braket.model.CreateJobRequest.ReadOnly {
    override val algorithmSpecification
        : zio.aws.braket.model.AlgorithmSpecification.ReadOnly =
      zio.aws.braket.model.AlgorithmSpecification
        .wrap(impl.algorithmSpecification())
    override val checkpointConfig
        : Option[zio.aws.braket.model.JobCheckpointConfig.ReadOnly] = scala
      .Option(impl.checkpointConfig())
      .map(value => zio.aws.braket.model.JobCheckpointConfig.wrap(value))
    override val clientToken: String64 =
      zio.aws.braket.model.primitives.String64(impl.clientToken())
    override val deviceConfig: zio.aws.braket.model.DeviceConfig.ReadOnly =
      zio.aws.braket.model.DeviceConfig.wrap(impl.deviceConfig())
    override val hyperParameters
        : Option[Map[String256, HyperParametersValueString]] = scala
      .Option(impl.hyperParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.braket.model.primitives
              .String256(key) -> zio.aws.braket.model.primitives
              .HyperParametersValueString(value)
          })
          .toMap
      )
    override val inputDataConfig
        : Option[List[zio.aws.braket.model.InputFileConfig.ReadOnly]] = scala
      .Option(impl.inputDataConfig())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.braket.model.InputFileConfig.wrap(item)
        }.toList
      )
    override val instanceConfig: zio.aws.braket.model.InstanceConfig.ReadOnly =
      zio.aws.braket.model.InstanceConfig.wrap(impl.instanceConfig())
    override val jobName: CreateJobRequestJobNameString =
      zio.aws.braket.model.primitives
        .CreateJobRequestJobNameString(impl.jobName())
    override val outputDataConfig
        : zio.aws.braket.model.JobOutputDataConfig.ReadOnly =
      zio.aws.braket.model.JobOutputDataConfig.wrap(impl.outputDataConfig())
    override val roleArn: RoleArn =
      zio.aws.braket.model.primitives.RoleArn(impl.roleArn())
    override val stoppingCondition
        : Option[zio.aws.braket.model.JobStoppingCondition.ReadOnly] = scala
      .Option(impl.stoppingCondition())
      .map(value => zio.aws.braket.model.JobStoppingCondition.wrap(value))
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.CreateJobRequest
  ): zio.aws.braket.model.CreateJobRequest.ReadOnly = new Wrapper(impl)
}
