package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AlgorithmSpecification(
    containerImage: Option[zio.aws.braket.model.ContainerImage] = None,
    scriptModeConfig: Option[zio.aws.braket.model.ScriptModeConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.AlgorithmSpecification = {
    import AlgorithmSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.AlgorithmSpecification
      .builder()
      .optionallyWith(containerImage.map(value => value.buildAwsValue()))(
        _.containerImage
      )
      .optionallyWith(scriptModeConfig.map(value => value.buildAwsValue()))(
        _.scriptModeConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.braket.model.AlgorithmSpecification.ReadOnly =
    zio.aws.braket.model.AlgorithmSpecification.wrap(buildAwsValue())
}
object AlgorithmSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.AlgorithmSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.AlgorithmSpecification =
      zio.aws.braket.model.AlgorithmSpecification(
        containerImage.map(value => value.asEditable),
        scriptModeConfig.map(value => value.asEditable)
      )
    def containerImage: Option[zio.aws.braket.model.ContainerImage.ReadOnly]
    def scriptModeConfig: Option[zio.aws.braket.model.ScriptModeConfig.ReadOnly]
    def getContainerImage
        : ZIO[Any, AwsError, zio.aws.braket.model.ContainerImage.ReadOnly] =
      AwsError.unwrapOptionField("containerImage", containerImage)
    def getScriptModeConfig
        : ZIO[Any, AwsError, zio.aws.braket.model.ScriptModeConfig.ReadOnly] =
      AwsError.unwrapOptionField("scriptModeConfig", scriptModeConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.AlgorithmSpecification
  ) extends zio.aws.braket.model.AlgorithmSpecification.ReadOnly {
    override val containerImage
        : Option[zio.aws.braket.model.ContainerImage.ReadOnly] = scala
      .Option(impl.containerImage())
      .map(value => zio.aws.braket.model.ContainerImage.wrap(value))
    override val scriptModeConfig
        : Option[zio.aws.braket.model.ScriptModeConfig.ReadOnly] = scala
      .Option(impl.scriptModeConfig())
      .map(value => zio.aws.braket.model.ScriptModeConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.AlgorithmSpecification
  ): zio.aws.braket.model.AlgorithmSpecification.ReadOnly = new Wrapper(impl)
}
