package zio.aws.braket
import zio.aws.braket.model.CreateQuantumTaskResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.braket.BraketAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.braket.model.{
  SearchDevicesRequest,
  SearchQuantumTasksRequest,
  CancelQuantumTaskRequest,
  CancelJobRequest,
  GetJobRequest,
  GetDeviceRequest,
  ListTagsForResourceRequest,
  UntagResourceRequest,
  CreateJobRequest,
  GetQuantumTaskRequest,
  SearchJobsRequest,
  CreateQuantumTaskRequest,
  TagResourceRequest
}
object BraketMock extends Mock[Braket] {
  object SearchQuantumTasks
      extends Stream[
        SearchQuantumTasksRequest,
        AwsError,
        zio.aws.braket.model.QuantumTaskSummary.ReadOnly
      ]
  object SearchQuantumTasksPaginated
      extends Effect[
        SearchQuantumTasksRequest,
        AwsError,
        zio.aws.braket.model.SearchQuantumTasksResponse.ReadOnly
      ]
  object CancelQuantumTask
      extends Effect[
        CancelQuantumTaskRequest,
        AwsError,
        zio.aws.braket.model.CancelQuantumTaskResponse.ReadOnly
      ]
  object CreateJob
      extends Effect[
        CreateJobRequest,
        AwsError,
        zio.aws.braket.model.CreateJobResponse.ReadOnly
      ]
  object CancelJob
      extends Effect[
        CancelJobRequest,
        AwsError,
        zio.aws.braket.model.CancelJobResponse.ReadOnly
      ]
  object SearchJobs
      extends Stream[
        SearchJobsRequest,
        AwsError,
        zio.aws.braket.model.JobSummary.ReadOnly
      ]
  object SearchJobsPaginated
      extends Effect[
        SearchJobsRequest,
        AwsError,
        zio.aws.braket.model.SearchJobsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.braket.model.UntagResourceResponse.ReadOnly
      ]
  object GetJob
      extends Effect[
        GetJobRequest,
        AwsError,
        zio.aws.braket.model.GetJobResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.braket.model.ListTagsForResourceResponse.ReadOnly
      ]
  object GetQuantumTask
      extends Effect[
        GetQuantumTaskRequest,
        AwsError,
        zio.aws.braket.model.GetQuantumTaskResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.braket.model.TagResourceResponse.ReadOnly
      ]
  object CreateQuantumTask
      extends Effect[CreateQuantumTaskRequest, AwsError, ReadOnly]
  object SearchDevices
      extends Stream[
        SearchDevicesRequest,
        AwsError,
        zio.aws.braket.model.DeviceSummary.ReadOnly
      ]
  object SearchDevicesPaginated
      extends Effect[
        SearchDevicesRequest,
        AwsError,
        zio.aws.braket.model.SearchDevicesResponse.ReadOnly
      ]
  object GetDevice
      extends Effect[
        GetDeviceRequest,
        AwsError,
        zio.aws.braket.model.GetDeviceResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Braket] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Braket {
          val api: BraketAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Braket = this
          def searchQuantumTasks(request: SearchQuantumTasksRequest): ZStream[
            Any,
            AwsError,
            zio.aws.braket.model.QuantumTaskSummary.ReadOnly
          ] = rts.unsafeRun(proxy(SearchQuantumTasks, request))
          def searchQuantumTasksPaginated(
              request: SearchQuantumTasksRequest
          ): IO[
            AwsError,
            zio.aws.braket.model.SearchQuantumTasksResponse.ReadOnly
          ] = proxy(SearchQuantumTasksPaginated, request)
          def cancelQuantumTask(request: CancelQuantumTaskRequest): IO[
            AwsError,
            zio.aws.braket.model.CancelQuantumTaskResponse.ReadOnly
          ] = proxy(CancelQuantumTask, request)
          def createJob(
              request: CreateJobRequest
          ): IO[AwsError, zio.aws.braket.model.CreateJobResponse.ReadOnly] =
            proxy(CreateJob, request)
          def cancelJob(
              request: CancelJobRequest
          ): IO[AwsError, zio.aws.braket.model.CancelJobResponse.ReadOnly] =
            proxy(CancelJob, request)
          def searchJobs(
              request: SearchJobsRequest
          ): ZStream[Any, AwsError, zio.aws.braket.model.JobSummary.ReadOnly] =
            rts.unsafeRun(proxy(SearchJobs, request))
          def searchJobsPaginated(
              request: SearchJobsRequest
          ): IO[AwsError, zio.aws.braket.model.SearchJobsResponse.ReadOnly] =
            proxy(SearchJobsPaginated, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, zio.aws.braket.model.UntagResourceResponse.ReadOnly] =
            proxy(UntagResource, request)
          def getJob(
              request: GetJobRequest
          ): IO[AwsError, zio.aws.braket.model.GetJobResponse.ReadOnly] =
            proxy(GetJob, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.braket.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def getQuantumTask(request: GetQuantumTaskRequest): IO[
            AwsError,
            zio.aws.braket.model.GetQuantumTaskResponse.ReadOnly
          ] = proxy(GetQuantumTask, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.braket.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def createQuantumTask(
              request: CreateQuantumTaskRequest
          ): IO[AwsError, ReadOnly] = proxy(CreateQuantumTask, request)
          def searchDevices(request: SearchDevicesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.braket.model.DeviceSummary.ReadOnly
          ] = rts.unsafeRun(proxy(SearchDevices, request))
          def searchDevicesPaginated(
              request: SearchDevicesRequest
          ): IO[AwsError, zio.aws.braket.model.SearchDevicesResponse.ReadOnly] =
            proxy(SearchDevicesPaginated, request)
          def getDevice(
              request: GetDeviceRequest
          ): IO[AwsError, zio.aws.braket.model.GetDeviceResponse.ReadOnly] =
            proxy(GetDevice, request)
        }
      }
    }
    .toLayer
}
