package zio.aws.braket
import zio.aws.core.config.AwsConfig
import zio.aws.braket.model.CreateQuantumTaskResponse.ReadOnly
import software.amazon.awssdk.services.braket.{
  BraketAsyncClientBuilder,
  BraketAsyncClient
}
import software.amazon.awssdk.services.braket.model.{
  SearchDevicesRequest,
  SearchDevicesResponse,
  SearchQuantumTasksRequest,
  SearchJobsResponse,
  CancelQuantumTaskRequest,
  CancelJobRequest,
  CancelJobResponse,
  GetQuantumTaskResponse,
  GetJobRequest,
  GetDeviceRequest,
  ListTagsForResourceRequest,
  GetJobResponse,
  ListTagsForResourceResponse,
  CreateQuantumTaskResponse,
  DeviceSummary,
  UntagResourceResponse,
  GetDeviceResponse,
  SearchQuantumTasksResponse,
  UntagResourceRequest,
  CreateJobRequest,
  CancelQuantumTaskResponse,
  QuantumTaskSummary,
  GetQuantumTaskRequest,
  SearchJobsRequest,
  CreateQuantumTaskRequest,
  TagResourceResponse,
  JobSummary,
  TagResourceRequest,
  CreateJobResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.braket.paginators.{
  SearchDevicesPublisher,
  SearchJobsPublisher,
  SearchQuantumTasksPublisher
}
import scala.jdk.CollectionConverters.*
trait Braket extends AspectSupport[Braket] {
  val api: BraketAsyncClient
  def searchQuantumTasks(
      request: zio.aws.braket.model.SearchQuantumTasksRequest
  ): ZStream[Any, AwsError, zio.aws.braket.model.QuantumTaskSummary.ReadOnly]
  def searchQuantumTasksPaginated(
      request: zio.aws.braket.model.SearchQuantumTasksRequest
  ): IO[AwsError, zio.aws.braket.model.SearchQuantumTasksResponse.ReadOnly]
  def cancelQuantumTask(
      request: zio.aws.braket.model.CancelQuantumTaskRequest
  ): IO[AwsError, zio.aws.braket.model.CancelQuantumTaskResponse.ReadOnly]
  def createJob(
      request: zio.aws.braket.model.CreateJobRequest
  ): IO[AwsError, zio.aws.braket.model.CreateJobResponse.ReadOnly]
  def cancelJob(
      request: zio.aws.braket.model.CancelJobRequest
  ): IO[AwsError, zio.aws.braket.model.CancelJobResponse.ReadOnly]
  def searchJobs(
      request: zio.aws.braket.model.SearchJobsRequest
  ): ZStream[Any, AwsError, zio.aws.braket.model.JobSummary.ReadOnly]
  def searchJobsPaginated(
      request: zio.aws.braket.model.SearchJobsRequest
  ): IO[AwsError, zio.aws.braket.model.SearchJobsResponse.ReadOnly]
  def untagResource(
      request: zio.aws.braket.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.braket.model.UntagResourceResponse.ReadOnly]
  def getJob(
      request: zio.aws.braket.model.GetJobRequest
  ): IO[AwsError, zio.aws.braket.model.GetJobResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.braket.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.braket.model.ListTagsForResourceResponse.ReadOnly]
  def getQuantumTask(
      request: zio.aws.braket.model.GetQuantumTaskRequest
  ): IO[AwsError, zio.aws.braket.model.GetQuantumTaskResponse.ReadOnly]
  def tagResource(
      request: zio.aws.braket.model.TagResourceRequest
  ): IO[AwsError, zio.aws.braket.model.TagResourceResponse.ReadOnly]
  def createQuantumTask(
      request: zio.aws.braket.model.CreateQuantumTaskRequest
  ): IO[AwsError, ReadOnly]
  def searchDevices(
      request: zio.aws.braket.model.SearchDevicesRequest
  ): ZStream[Any, AwsError, zio.aws.braket.model.DeviceSummary.ReadOnly]
  def searchDevicesPaginated(
      request: zio.aws.braket.model.SearchDevicesRequest
  ): IO[AwsError, zio.aws.braket.model.SearchDevicesResponse.ReadOnly]
  def getDevice(
      request: zio.aws.braket.model.GetDeviceRequest
  ): IO[AwsError, zio.aws.braket.model.GetDeviceResponse.ReadOnly]
}
object Braket {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Braket] = customized(
    identity
  )
  def customized(
      customization: BraketAsyncClientBuilder => BraketAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Braket] = managed(
    customization
  ).toLayer
  def managed(
      customization: BraketAsyncClientBuilder => BraketAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Braket] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = BraketAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[BraketAsyncClient, BraketAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[BraketAsyncClient, BraketAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new BraketImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class BraketImpl[R](
      override val api: BraketAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Braket
      with AwsServiceBase[R] {
    override val serviceName: String = "Braket"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): BraketImpl[R1] = new BraketImpl(api, newAspect, r)
    def searchQuantumTasks(
        request: zio.aws.braket.model.SearchQuantumTasksRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.braket.model.QuantumTaskSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      SearchQuantumTasksRequest,
      QuantumTaskSummary,
      SearchQuantumTasksPublisher
    ]("searchQuantumTasks", api.searchQuantumTasksPaginator, _.quantumTasks())(
      request.buildAwsValue()
    ).map(item => zio.aws.braket.model.QuantumTaskSummary.wrap(item))
      .provideEnvironment(r)
    def searchQuantumTasksPaginated(
        request: zio.aws.braket.model.SearchQuantumTasksRequest
    ): IO[AwsError, zio.aws.braket.model.SearchQuantumTasksResponse.ReadOnly] =
      asyncRequestResponse[
        SearchQuantumTasksRequest,
        SearchQuantumTasksResponse
      ]("searchQuantumTasks", api.searchQuantumTasks)(request.buildAwsValue())
        .map(zio.aws.braket.model.SearchQuantumTasksResponse.wrap)
        .provideEnvironment(r)
    def cancelQuantumTask(
        request: zio.aws.braket.model.CancelQuantumTaskRequest
    ): IO[AwsError, zio.aws.braket.model.CancelQuantumTaskResponse.ReadOnly] =
      asyncRequestResponse[CancelQuantumTaskRequest, CancelQuantumTaskResponse](
        "cancelQuantumTask",
        api.cancelQuantumTask
      )(request.buildAwsValue())
        .map(zio.aws.braket.model.CancelQuantumTaskResponse.wrap)
        .provideEnvironment(r)
    def createJob(
        request: zio.aws.braket.model.CreateJobRequest
    ): IO[AwsError, zio.aws.braket.model.CreateJobResponse.ReadOnly] =
      asyncRequestResponse[CreateJobRequest, CreateJobResponse](
        "createJob",
        api.createJob
      )(request.buildAwsValue())
        .map(zio.aws.braket.model.CreateJobResponse.wrap)
        .provideEnvironment(r)
    def cancelJob(
        request: zio.aws.braket.model.CancelJobRequest
    ): IO[AwsError, zio.aws.braket.model.CancelJobResponse.ReadOnly] =
      asyncRequestResponse[CancelJobRequest, CancelJobResponse](
        "cancelJob",
        api.cancelJob
      )(request.buildAwsValue())
        .map(zio.aws.braket.model.CancelJobResponse.wrap)
        .provideEnvironment(r)
    def searchJobs(
        request: zio.aws.braket.model.SearchJobsRequest
    ): ZStream[Any, AwsError, zio.aws.braket.model.JobSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        SearchJobsRequest,
        JobSummary,
        SearchJobsPublisher
      ]("searchJobs", api.searchJobsPaginator, _.jobs())(
        request.buildAwsValue()
      ).map(item => zio.aws.braket.model.JobSummary.wrap(item))
        .provideEnvironment(r)
    def searchJobsPaginated(
        request: zio.aws.braket.model.SearchJobsRequest
    ): IO[AwsError, zio.aws.braket.model.SearchJobsResponse.ReadOnly] =
      asyncRequestResponse[SearchJobsRequest, SearchJobsResponse](
        "searchJobs",
        api.searchJobs
      )(request.buildAwsValue())
        .map(zio.aws.braket.model.SearchJobsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.braket.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.braket.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.braket.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def getJob(
        request: zio.aws.braket.model.GetJobRequest
    ): IO[AwsError, zio.aws.braket.model.GetJobResponse.ReadOnly] =
      asyncRequestResponse[GetJobRequest, GetJobResponse]("getJob", api.getJob)(
        request.buildAwsValue()
      ).map(zio.aws.braket.model.GetJobResponse.wrap).provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.braket.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.braket.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.braket.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def getQuantumTask(
        request: zio.aws.braket.model.GetQuantumTaskRequest
    ): IO[AwsError, zio.aws.braket.model.GetQuantumTaskResponse.ReadOnly] =
      asyncRequestResponse[GetQuantumTaskRequest, GetQuantumTaskResponse](
        "getQuantumTask",
        api.getQuantumTask
      )(request.buildAwsValue())
        .map(zio.aws.braket.model.GetQuantumTaskResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.braket.model.TagResourceRequest
    ): IO[AwsError, zio.aws.braket.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.braket.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def createQuantumTask(
        request: zio.aws.braket.model.CreateQuantumTaskRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[CreateQuantumTaskRequest, CreateQuantumTaskResponse](
        "createQuantumTask",
        api.createQuantumTask
      )(request.buildAwsValue())
        .map(zio.aws.braket.model.CreateQuantumTaskResponse.wrap)
        .provideEnvironment(r)
    def searchDevices(
        request: zio.aws.braket.model.SearchDevicesRequest
    ): ZStream[Any, AwsError, zio.aws.braket.model.DeviceSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        SearchDevicesRequest,
        DeviceSummary,
        SearchDevicesPublisher
      ]("searchDevices", api.searchDevicesPaginator, _.devices())(
        request.buildAwsValue()
      ).map(item => zio.aws.braket.model.DeviceSummary.wrap(item))
        .provideEnvironment(r)
    def searchDevicesPaginated(
        request: zio.aws.braket.model.SearchDevicesRequest
    ): IO[AwsError, zio.aws.braket.model.SearchDevicesResponse.ReadOnly] =
      asyncRequestResponse[SearchDevicesRequest, SearchDevicesResponse](
        "searchDevices",
        api.searchDevices
      )(request.buildAwsValue())
        .map(zio.aws.braket.model.SearchDevicesResponse.wrap)
        .provideEnvironment(r)
    def getDevice(
        request: zio.aws.braket.model.GetDeviceRequest
    ): IO[AwsError, zio.aws.braket.model.GetDeviceResponse.ReadOnly] =
      asyncRequestResponse[GetDeviceRequest, GetDeviceResponse](
        "getDevice",
        api.getDevice
      )(request.buildAwsValue())
        .map(zio.aws.braket.model.GetDeviceResponse.wrap)
        .provideEnvironment(r)
  }
  def searchQuantumTasks(
      request: zio.aws.braket.model.SearchQuantumTasksRequest
  ): ZStream[
    zio.aws.braket.Braket,
    AwsError,
    zio.aws.braket.model.QuantumTaskSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchQuantumTasks(request))
  def searchQuantumTasksPaginated(
      request: zio.aws.braket.model.SearchQuantumTasksRequest
  ): ZIO[
    zio.aws.braket.Braket,
    AwsError,
    zio.aws.braket.model.SearchQuantumTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchQuantumTasksPaginated(request))
  def cancelQuantumTask(
      request: zio.aws.braket.model.CancelQuantumTaskRequest
  ): ZIO[
    zio.aws.braket.Braket,
    AwsError,
    zio.aws.braket.model.CancelQuantumTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelQuantumTask(request))
  def createJob(request: zio.aws.braket.model.CreateJobRequest): ZIO[
    zio.aws.braket.Braket,
    AwsError,
    zio.aws.braket.model.CreateJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createJob(request))
  def cancelJob(request: zio.aws.braket.model.CancelJobRequest): ZIO[
    zio.aws.braket.Braket,
    AwsError,
    zio.aws.braket.model.CancelJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelJob(request))
  def searchJobs(request: zio.aws.braket.model.SearchJobsRequest): ZStream[
    zio.aws.braket.Braket,
    AwsError,
    zio.aws.braket.model.JobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchJobs(request))
  def searchJobsPaginated(request: zio.aws.braket.model.SearchJobsRequest): ZIO[
    zio.aws.braket.Braket,
    AwsError,
    zio.aws.braket.model.SearchJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchJobsPaginated(request))
  def untagResource(request: zio.aws.braket.model.UntagResourceRequest): ZIO[
    zio.aws.braket.Braket,
    AwsError,
    zio.aws.braket.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getJob(request: zio.aws.braket.model.GetJobRequest): ZIO[
    zio.aws.braket.Braket,
    AwsError,
    zio.aws.braket.model.GetJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJob(request))
  def listTagsForResource(
      request: zio.aws.braket.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.braket.Braket,
    AwsError,
    zio.aws.braket.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def getQuantumTask(request: zio.aws.braket.model.GetQuantumTaskRequest): ZIO[
    zio.aws.braket.Braket,
    AwsError,
    zio.aws.braket.model.GetQuantumTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQuantumTask(request))
  def tagResource(request: zio.aws.braket.model.TagResourceRequest): ZIO[
    zio.aws.braket.Braket,
    AwsError,
    zio.aws.braket.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def createQuantumTask(
      request: zio.aws.braket.model.CreateQuantumTaskRequest
  ): ZIO[zio.aws.braket.Braket, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createQuantumTask(request))
  def searchDevices(
      request: zio.aws.braket.model.SearchDevicesRequest
  ): ZStream[
    zio.aws.braket.Braket,
    AwsError,
    zio.aws.braket.model.DeviceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchDevices(request))
  def searchDevicesPaginated(
      request: zio.aws.braket.model.SearchDevicesRequest
  ): ZIO[
    zio.aws.braket.Braket,
    AwsError,
    zio.aws.braket.model.SearchDevicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchDevicesPaginated(request))
  def getDevice(request: zio.aws.braket.model.GetDeviceRequest): ZIO[
    zio.aws.braket.Braket,
    AwsError,
    zio.aws.braket.model.GetDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDevice(request))
}
