package zio.aws.bedrockruntime.model
import zio.ZIO
import zio.aws.bedrockruntime.model.primitives.PartBody
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PayloadPart(bytes: Optional[PartBody] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrockruntime.model.PayloadPart = {
    import PayloadPart.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrockruntime.model.PayloadPart
      .builder()
      .optionallyWith(
        bytes.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.bytes)
      .build()
  }
  def asReadOnly: zio.aws.bedrockruntime.model.PayloadPart.ReadOnly =
    zio.aws.bedrockruntime.model.PayloadPart.wrap(buildAwsValue())
}
object PayloadPart {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrockruntime.model.PayloadPart
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrockruntime.model.PayloadPart =
      zio.aws.bedrockruntime.model.PayloadPart(bytes.map(value => value))
    def bytes: Optional[PartBody]
    def getBytes: ZIO[Any, AwsError, PartBody] =
      AwsError.unwrapOptionField("bytes", bytes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrockruntime.model.PayloadPart
  ) extends zio.aws.bedrockruntime.model.PayloadPart.ReadOnly {
    override val bytes: Optional[PartBody] = zio.aws.core.internal
      .optionalFromNullable(impl.bytes())
      .map(value =>
        zio.aws.bedrockruntime.model.primitives
          .PartBody(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrockruntime.model.PayloadPart
  ): zio.aws.bedrockruntime.model.PayloadPart.ReadOnly = new Wrapper(impl)
}
