package zio.aws.bedrockruntime.model
import zio.ZIO
import zio.aws.bedrockruntime.model.primitives.{MimeType, Body}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InvokeModelResponse(body: Body, contentType: MimeType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse = {
    import InvokeModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse
      .builder()
      .body(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(body.toArray[Byte])
      )
      .contentType(MimeType.unwrap(contentType): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.bedrockruntime.model.InvokeModelResponse.ReadOnly =
    zio.aws.bedrockruntime.model.InvokeModelResponse.wrap(buildAwsValue())
}
object InvokeModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrockruntime.model.InvokeModelResponse =
      zio.aws.bedrockruntime.model.InvokeModelResponse(body, contentType)
    def body: Body
    def contentType: MimeType
    def getBody: ZIO[Any, Nothing, Body] = ZIO.succeed(body)
    def getContentType: ZIO[Any, Nothing, MimeType] = ZIO.succeed(contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse
  ) extends zio.aws.bedrockruntime.model.InvokeModelResponse.ReadOnly {
    override val body: Body = zio.aws.bedrockruntime.model.primitives
      .Body(zio.Chunk.fromArray(impl.body().asByteArrayUnsafe()))
    override val contentType: MimeType =
      zio.aws.bedrockruntime.model.primitives.MimeType(impl.contentType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse
  ): zio.aws.bedrockruntime.model.InvokeModelResponse.ReadOnly = new Wrapper(
    impl
  )
}
