package zio.aws.bedrockruntime
import zio.mock.{Proxy, Mock}
import zio.aws.bedrockruntime.model.{
  InvokeModelWithResponseStreamRequest,
  InvokeModelRequest
}
import zio.aws.core.AwsError
import zio.aws.bedrockruntime.model.InvokeModelResponse.ReadOnly
import zio.aws.core.aspects.AwsCallAspect
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object BedrockRuntimeMock extends Mock[BedrockRuntime] {
  object InvokeModel extends Effect[InvokeModelRequest, AwsError, ReadOnly]
  object InvokeModelWithResponseStream
      extends Stream[
        InvokeModelWithResponseStreamRequest,
        AwsError,
        zio.aws.bedrockruntime.model.PayloadPart.ReadOnly
      ]
  val compose: URLayer[Proxy, BedrockRuntime] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, BedrockRuntime] { rts =>
        zio.ZIO.succeed {
          new BedrockRuntime {
            val api: BedrockRuntimeAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): BedrockRuntime = this
            def invokeModel(
                request: InvokeModelRequest
            ): IO[AwsError, ReadOnly] = proxy(InvokeModel, request)
            def invokeModelWithResponseStream(
                request: InvokeModelWithResponseStreamRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.bedrockruntime.model.PayloadPart.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(InvokeModelWithResponseStream, request)
                }
                .getOrThrowFiberFailure()
            }
          }
        }
      }
    }
  }
}
