package zio.aws.bedrockruntime
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.bedrockruntime.model.{
  InvokeModelRequest,
  InvokeModelWithResponseStreamResponse,
  InvokeModelResponse,
  ResponseStream,
  InvokeModelWithResponseStreamResponseHandler,
  InvokeModelWithResponseStreamRequest,
  PayloadPart
}
import software.amazon.awssdk.core.async.SdkPublisher
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.bedrockruntime.model.InvokeModelResponse.ReadOnly
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.bedrockruntime.{
  BedrockRuntimeAsyncClientBuilder,
  BedrockRuntimeAsyncClient
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandler
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait BedrockRuntime extends AspectSupport[BedrockRuntime] {
  val api: BedrockRuntimeAsyncClient
  def invokeModel(
      request: zio.aws.bedrockruntime.model.InvokeModelRequest
  ): IO[AwsError, ReadOnly]
  def invokeModelWithResponseStream(
      request: zio.aws.bedrockruntime.model.InvokeModelWithResponseStreamRequest
  ): ZStream[Any, AwsError, zio.aws.bedrockruntime.model.PayloadPart.ReadOnly]
}
object BedrockRuntime {
  val live: ZLayer[AwsConfig, java.lang.Throwable, BedrockRuntime] = customized(
    identity
  )
  def customized(
      customization: BedrockRuntimeAsyncClientBuilder => BedrockRuntimeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, BedrockRuntime] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: BedrockRuntimeAsyncClientBuilder => BedrockRuntimeAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, BedrockRuntime] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = BedrockRuntimeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[BedrockRuntimeAsyncClient, BedrockRuntimeAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      BedrockRuntimeAsyncClient,
      BedrockRuntimeAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new BedrockRuntimeImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class BedrockRuntimeImpl[R](
      override val api: BedrockRuntimeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends BedrockRuntime
      with AwsServiceBase[R] {
    override val serviceName: String = "BedrockRuntime"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): BedrockRuntimeImpl[R1] = new BedrockRuntimeImpl(api, newAspect, r)
    def invokeModel(
        request: zio.aws.bedrockruntime.model.InvokeModelRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[InvokeModelRequest, InvokeModelResponse](
        "invokeModel",
        api.invokeModel
      )(request.buildAwsValue())
        .map(zio.aws.bedrockruntime.model.InvokeModelResponse.wrap)
        .provideEnvironment(r)
    def invokeModelWithResponseStream(
        request: zio.aws.bedrockruntime.model.InvokeModelWithResponseStreamRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.bedrockruntime.model.PayloadPart.ReadOnly
    ] = asyncRequestEventOutputStream[
      InvokeModelWithResponseStreamRequest,
      InvokeModelWithResponseStreamResponse,
      InvokeModelWithResponseStreamResponseHandler,
      ResponseStream,
      PayloadPart
    ](
      "InvokeModelWithResponseStream",
      (
          request: InvokeModelWithResponseStreamRequest,
          handler: InvokeModelWithResponseStreamResponseHandler
      ) => api.invokeModelWithResponseStream(request, handler),
      (impl: EventStreamResponseHandler[
        InvokeModelWithResponseStreamResponse,
        ResponseStream
      ]) =>
        new InvokeModelWithResponseStreamResponseHandler {
          override def responseReceived(
              response: InvokeModelWithResponseStreamResponse
          ): Unit = impl.responseReceived(response)
          override def onEventStream(
              publisher: SdkPublisher[ResponseStream]
          ): Unit = impl.onEventStream(publisher)
          override def exceptionOccurred(throwable: java.lang.Throwable): Unit =
            impl.exceptionOccurred(throwable)
          override def complete(): Unit = impl.complete()
        }
    )(request.buildAwsValue())
      .map(item => zio.aws.bedrockruntime.model.PayloadPart.wrap(item))
      .provideEnvironment(r)
  }
  def invokeModel(
      request: zio.aws.bedrockruntime.model.InvokeModelRequest
  ): ZIO[zio.aws.bedrockruntime.BedrockRuntime, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.invokeModel(request))
  def invokeModelWithResponseStream(
      request: zio.aws.bedrockruntime.model.InvokeModelWithResponseStreamRequest
  ): ZStream[
    zio.aws.bedrockruntime.BedrockRuntime,
    AwsError,
    zio.aws.bedrockruntime.model.PayloadPart.ReadOnly
  ] = ZStream.serviceWithStream(_.invokeModelWithResponseStream(request))
}
