package zio.aws.bedrockruntime.model
import zio.ZIO
import zio.aws.bedrockruntime.model.primitives.{
  InvokeModelIdentifier,
  Body,
  MimeType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InvokeModelRequest(
    accept: Optional[MimeType] = Optional.Absent,
    body: Body,
    contentType: Optional[MimeType] = Optional.Absent,
    modelId: InvokeModelIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest = {
    import InvokeModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest
      .builder()
      .optionallyWith(
        accept.map(value => MimeType.unwrap(value): java.lang.String)
      )(_.accept)
      .body(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(body.toArray[Byte])
      )
      .optionallyWith(
        contentType.map(value => MimeType.unwrap(value): java.lang.String)
      )(_.contentType)
      .modelId(InvokeModelIdentifier.unwrap(modelId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.bedrockruntime.model.InvokeModelRequest.ReadOnly =
    zio.aws.bedrockruntime.model.InvokeModelRequest.wrap(buildAwsValue())
}
object InvokeModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrockruntime.model.InvokeModelRequest =
      zio.aws.bedrockruntime.model.InvokeModelRequest(
        accept.map(value => value),
        body,
        contentType.map(value => value),
        modelId
      )
    def accept: Optional[MimeType]
    def body: Body
    def contentType: Optional[MimeType]
    def modelId: InvokeModelIdentifier
    def getAccept: ZIO[Any, AwsError, MimeType] =
      AwsError.unwrapOptionField("accept", accept)
    def getBody: ZIO[Any, Nothing, Body] = ZIO.succeed(body)
    def getContentType: ZIO[Any, AwsError, MimeType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getModelId: ZIO[Any, Nothing, InvokeModelIdentifier] =
      ZIO.succeed(modelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest
  ) extends zio.aws.bedrockruntime.model.InvokeModelRequest.ReadOnly {
    override val accept: Optional[MimeType] = zio.aws.core.internal
      .optionalFromNullable(impl.accept())
      .map(value => zio.aws.bedrockruntime.model.primitives.MimeType(value))
    override val body: Body = zio.aws.bedrockruntime.model.primitives
      .Body(zio.Chunk.fromArray(impl.body().asByteArrayUnsafe()))
    override val contentType: Optional[MimeType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.bedrockruntime.model.primitives.MimeType(value))
    override val modelId: InvokeModelIdentifier =
      zio.aws.bedrockruntime.model.primitives
        .InvokeModelIdentifier(impl.modelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest
  ): zio.aws.bedrockruntime.model.InvokeModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
