package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LinuxParameters(
    devices: Optional[Iterable[zio.aws.batch.model.Device]] = Optional.Absent,
    initProcessEnabled: Optional[Boolean] = Optional.Absent,
    sharedMemorySize: Optional[Integer] = Optional.Absent,
    tmpfs: Optional[Iterable[zio.aws.batch.model.Tmpfs]] = Optional.Absent,
    maxSwap: Optional[Integer] = Optional.Absent,
    swappiness: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.LinuxParameters = {
    import LinuxParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.LinuxParameters
      .builder()
      .optionallyWith(
        devices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.devices)
      .optionallyWith(
        initProcessEnabled.map(value => value: java.lang.Boolean)
      )(_.initProcessEnabled)
      .optionallyWith(sharedMemorySize.map(value => value: java.lang.Integer))(
        _.sharedMemorySize
      )
      .optionallyWith(
        tmpfs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tmpfs)
      .optionallyWith(maxSwap.map(value => value: java.lang.Integer))(_.maxSwap)
      .optionallyWith(swappiness.map(value => value: java.lang.Integer))(
        _.swappiness
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.LinuxParameters.ReadOnly =
    zio.aws.batch.model.LinuxParameters.wrap(buildAwsValue())
}
object LinuxParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.LinuxParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.LinuxParameters =
      zio.aws.batch.model.LinuxParameters(
        devices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        initProcessEnabled.map(value => value),
        sharedMemorySize.map(value => value),
        tmpfs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxSwap.map(value => value),
        swappiness.map(value => value)
      )
    def devices: Optional[List[zio.aws.batch.model.Device.ReadOnly]]
    def initProcessEnabled: Optional[Boolean]
    def sharedMemorySize: Optional[Integer]
    def tmpfs: Optional[List[zio.aws.batch.model.Tmpfs.ReadOnly]]
    def maxSwap: Optional[Integer]
    def swappiness: Optional[Integer]
    def getDevices
        : ZIO[Any, AwsError, List[zio.aws.batch.model.Device.ReadOnly]] =
      AwsError.unwrapOptionField("devices", devices)
    def getInitProcessEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("initProcessEnabled", initProcessEnabled)
    def getSharedMemorySize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sharedMemorySize", sharedMemorySize)
    def getTmpfs: ZIO[Any, AwsError, List[zio.aws.batch.model.Tmpfs.ReadOnly]] =
      AwsError.unwrapOptionField("tmpfs", tmpfs)
    def getMaxSwap: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxSwap", maxSwap)
    def getSwappiness: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("swappiness", swappiness)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.LinuxParameters
  ) extends zio.aws.batch.model.LinuxParameters.ReadOnly {
    override val devices: Optional[List[zio.aws.batch.model.Device.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.devices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.Device.wrap(item)
          }.toList
        )
    override val initProcessEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.initProcessEnabled())
      .map(value => value: Boolean)
    override val sharedMemorySize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sharedMemorySize())
      .map(value => value: Integer)
    override val tmpfs: Optional[List[zio.aws.batch.model.Tmpfs.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tmpfs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.Tmpfs.wrap(item)
          }.toList
        )
    override val maxSwap: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxSwap())
      .map(value => value: Integer)
    override val swappiness: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.swappiness())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.LinuxParameters
  ): zio.aws.batch.model.LinuxParameters.ReadOnly = new Wrapper(impl)
}
