package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait CRUpdateAllocationStrategy {
  def unwrap
      : software.amazon.awssdk.services.batch.model.CRUpdateAllocationStrategy
}
object CRUpdateAllocationStrategy {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.CRUpdateAllocationStrategy
  ): zio.aws.batch.model.CRUpdateAllocationStrategy = value match {
    case software.amazon.awssdk.services.batch.model.CRUpdateAllocationStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.CRUpdateAllocationStrategy.BEST_FIT_PROGRESSIVE =>
      val r = BEST_FIT_PROGRESSIVE
      r
    case software.amazon.awssdk.services.batch.model.CRUpdateAllocationStrategy.SPOT_CAPACITY_OPTIMIZED =>
      val r = SPOT_CAPACITY_OPTIMIZED
      r
    case software.amazon.awssdk.services.batch.model.CRUpdateAllocationStrategy.SPOT_PRICE_CAPACITY_OPTIMIZED =>
      val r = SPOT_PRICE_CAPACITY_OPTIMIZED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.batch.model.CRUpdateAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.CRUpdateAllocationStrategy =
      software.amazon.awssdk.services.batch.model.CRUpdateAllocationStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object BEST_FIT_PROGRESSIVE
      extends zio.aws.batch.model.CRUpdateAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.CRUpdateAllocationStrategy =
      software.amazon.awssdk.services.batch.model.CRUpdateAllocationStrategy.BEST_FIT_PROGRESSIVE
  }
  case object SPOT_CAPACITY_OPTIMIZED
      extends zio.aws.batch.model.CRUpdateAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.CRUpdateAllocationStrategy =
      software.amazon.awssdk.services.batch.model.CRUpdateAllocationStrategy.SPOT_CAPACITY_OPTIMIZED
  }
  case object SPOT_PRICE_CAPACITY_OPTIMIZED
      extends zio.aws.batch.model.CRUpdateAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.CRUpdateAllocationStrategy =
      software.amazon.awssdk.services.batch.model.CRUpdateAllocationStrategy.SPOT_PRICE_CAPACITY_OPTIMIZED
  }
}
