package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuntimePlatform(
    operatingSystemFamily: Optional[String] = Optional.Absent,
    cpuArchitecture: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.RuntimePlatform = {
    import RuntimePlatform.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.RuntimePlatform
      .builder()
      .optionallyWith(
        operatingSystemFamily.map(value => value: java.lang.String)
      )(_.operatingSystemFamily)
      .optionallyWith(cpuArchitecture.map(value => value: java.lang.String))(
        _.cpuArchitecture
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.RuntimePlatform.ReadOnly =
    zio.aws.batch.model.RuntimePlatform.wrap(buildAwsValue())
}
object RuntimePlatform {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.RuntimePlatform
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.RuntimePlatform =
      zio.aws.batch.model.RuntimePlatform(
        operatingSystemFamily.map(value => value),
        cpuArchitecture.map(value => value)
      )
    def operatingSystemFamily: Optional[String]
    def cpuArchitecture: Optional[String]
    def getOperatingSystemFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operatingSystemFamily", operatingSystemFamily)
    def getCpuArchitecture: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cpuArchitecture", cpuArchitecture)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.RuntimePlatform
  ) extends zio.aws.batch.model.RuntimePlatform.ReadOnly {
    override val operatingSystemFamily: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.operatingSystemFamily())
      .map(value => value: String)
    override val cpuArchitecture: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cpuArchitecture())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.RuntimePlatform
  ): zio.aws.batch.model.RuntimePlatform.ReadOnly = new Wrapper(impl)
}
