package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeSchedulingPoliciesResponse(
    schedulingPolicies: Optional[
      Iterable[zio.aws.batch.model.SchedulingPolicyDetail]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.DescribeSchedulingPoliciesResponse = {
    import DescribeSchedulingPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.DescribeSchedulingPoliciesResponse
      .builder()
      .optionallyWith(
        schedulingPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schedulingPolicies)
      .build()
  }
  def asReadOnly
      : zio.aws.batch.model.DescribeSchedulingPoliciesResponse.ReadOnly =
    zio.aws.batch.model.DescribeSchedulingPoliciesResponse.wrap(buildAwsValue())
}
object DescribeSchedulingPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.DescribeSchedulingPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.DescribeSchedulingPoliciesResponse =
      zio.aws.batch.model.DescribeSchedulingPoliciesResponse(
        schedulingPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def schedulingPolicies
        : Optional[List[zio.aws.batch.model.SchedulingPolicyDetail.ReadOnly]]
    def getSchedulingPolicies: ZIO[Any, AwsError, List[
      zio.aws.batch.model.SchedulingPolicyDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("schedulingPolicies", schedulingPolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.DescribeSchedulingPoliciesResponse
  ) extends zio.aws.batch.model.DescribeSchedulingPoliciesResponse.ReadOnly {
    override val schedulingPolicies
        : Optional[List[zio.aws.batch.model.SchedulingPolicyDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedulingPolicies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.SchedulingPolicyDetail.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.DescribeSchedulingPoliciesResponse
  ): zio.aws.batch.model.DescribeSchedulingPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
