package zio.aws.batch.model
import zio.aws.batch.model.primitives.{TagValue, TagKey, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobQueueDetail(
    jobQueueName: String,
    jobQueueArn: String,
    state: zio.aws.batch.model.JQState,
    schedulingPolicyArn: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.batch.model.JQStatus] = Optional.Absent,
    statusReason: Optional[String] = Optional.Absent,
    priority: Integer,
    computeEnvironmentOrder: Iterable[
      zio.aws.batch.model.ComputeEnvironmentOrder
    ],
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.JobQueueDetail = {
    import JobQueueDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.JobQueueDetail
      .builder()
      .jobQueueName(jobQueueName: java.lang.String)
      .jobQueueArn(jobQueueArn: java.lang.String)
      .state(state.unwrap)
      .optionallyWith(
        schedulingPolicyArn.map(value => value: java.lang.String)
      )(_.schedulingPolicyArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .priority(priority: java.lang.Integer)
      .computeEnvironmentOrder(computeEnvironmentOrder.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.JobQueueDetail.ReadOnly =
    zio.aws.batch.model.JobQueueDetail.wrap(buildAwsValue())
}
object JobQueueDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.JobQueueDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.JobQueueDetail =
      zio.aws.batch.model.JobQueueDetail(
        jobQueueName,
        jobQueueArn,
        state,
        schedulingPolicyArn.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        priority,
        computeEnvironmentOrder.map { item =>
          item.asEditable
        },
        tags.map(value => value)
      )
    def jobQueueName: String
    def jobQueueArn: String
    def state: zio.aws.batch.model.JQState
    def schedulingPolicyArn: Optional[String]
    def status: Optional[zio.aws.batch.model.JQStatus]
    def statusReason: Optional[String]
    def priority: Integer
    def computeEnvironmentOrder
        : List[zio.aws.batch.model.ComputeEnvironmentOrder.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getJobQueueName: ZIO[Any, Nothing, String] = ZIO.succeed(jobQueueName)
    def getJobQueueArn: ZIO[Any, Nothing, String] = ZIO.succeed(jobQueueArn)
    def getState: ZIO[Any, Nothing, zio.aws.batch.model.JQState] =
      ZIO.succeed(state)
    def getSchedulingPolicyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schedulingPolicyArn", schedulingPolicyArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.batch.model.JQStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getPriority: ZIO[Any, Nothing, Integer] = ZIO.succeed(priority)
    def getComputeEnvironmentOrder: ZIO[Any, Nothing, List[
      zio.aws.batch.model.ComputeEnvironmentOrder.ReadOnly
    ]] = ZIO.succeed(computeEnvironmentOrder)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.JobQueueDetail
  ) extends zio.aws.batch.model.JobQueueDetail.ReadOnly {
    override val jobQueueName: String = impl.jobQueueName(): String
    override val jobQueueArn: String = impl.jobQueueArn(): String
    override val state: zio.aws.batch.model.JQState =
      zio.aws.batch.model.JQState.wrap(impl.state())
    override val schedulingPolicyArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schedulingPolicyArn())
      .map(value => value: String)
    override val status: Optional[zio.aws.batch.model.JQStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.batch.model.JQStatus.wrap(value))
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
    override val priority: Integer = impl.priority(): Integer
    override val computeEnvironmentOrder
        : List[zio.aws.batch.model.ComputeEnvironmentOrder.ReadOnly] = impl
      .computeEnvironmentOrder()
      .asScala
      .map { item =>
        zio.aws.batch.model.ComputeEnvironmentOrder.wrap(item)
      }
      .toList
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.batch.model.primitives
              .TagKey(key) -> zio.aws.batch.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.JobQueueDetail
  ): zio.aws.batch.model.JobQueueDetail.ReadOnly = new Wrapper(impl)
}
