package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait ArrayJobDependency {
  def unwrap: software.amazon.awssdk.services.batch.model.ArrayJobDependency
}
object ArrayJobDependency {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.ArrayJobDependency
  ): zio.aws.batch.model.ArrayJobDependency = value match {
    case software.amazon.awssdk.services.batch.model.ArrayJobDependency.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.ArrayJobDependency.N_TO_N =>
      val r = N_TO_N
      r
    case software.amazon.awssdk.services.batch.model.ArrayJobDependency.SEQUENTIAL =>
      val r = SEQUENTIAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.batch.model.ArrayJobDependency {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.ArrayJobDependency =
      software.amazon.awssdk.services.batch.model.ArrayJobDependency.UNKNOWN_TO_SDK_VERSION
  }
  case object N_TO_N extends zio.aws.batch.model.ArrayJobDependency {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.ArrayJobDependency =
      software.amazon.awssdk.services.batch.model.ArrayJobDependency.N_TO_N
  }
  case object SEQUENTIAL extends zio.aws.batch.model.ArrayJobDependency {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.ArrayJobDependency =
      software.amazon.awssdk.services.batch.model.ArrayJobDependency.SEQUENTIAL
  }
}
