package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EphemeralStorage(sizeInGiB: Integer) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EphemeralStorage = {
    import EphemeralStorage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EphemeralStorage
      .builder()
      .sizeInGiB(sizeInGiB: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EphemeralStorage.ReadOnly =
    zio.aws.batch.model.EphemeralStorage.wrap(buildAwsValue())
}
object EphemeralStorage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EphemeralStorage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EphemeralStorage =
      zio.aws.batch.model.EphemeralStorage(sizeInGiB)
    def sizeInGiB: Integer
    def getSizeInGiB: ZIO[Any, Nothing, Integer] = ZIO.succeed(sizeInGiB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EphemeralStorage
  ) extends zio.aws.batch.model.EphemeralStorage.ReadOnly {
    override val sizeInGiB: Integer = impl.sizeInGiB(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EphemeralStorage
  ): zio.aws.batch.model.EphemeralStorage.ReadOnly = new Wrapper(impl)
}
