package zio.aws.batch
import zio.aws.batch.model.SubmitJobResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.batch.model.{
  ListSchedulingPoliciesRequest,
  DescribeJobQueuesRequest,
  SubmitJobRequest,
  CreateSchedulingPolicyRequest,
  DeleteComputeEnvironmentRequest,
  CancelJobRequest,
  UpdateJobQueueRequest,
  ListJobsRequest,
  CreateComputeEnvironmentRequest,
  UpdateComputeEnvironmentRequest,
  DescribeSchedulingPoliciesRequest,
  ListTagsForResourceRequest,
  DeleteSchedulingPolicyRequest,
  DescribeComputeEnvironmentsRequest,
  UpdateSchedulingPolicyRequest,
  DeleteJobQueueRequest,
  DescribeJobsRequest,
  DeregisterJobDefinitionRequest,
  RegisterJobDefinitionRequest,
  DescribeJobDefinitionsRequest,
  TerminateJobRequest,
  UntagResourceRequest,
  CreateJobQueueRequest,
  TagResourceRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.batch.paginators.{
  ListSchedulingPoliciesPublisher,
  DescribeComputeEnvironmentsPublisher,
  DescribeJobDefinitionsPublisher,
  ListJobsPublisher,
  DescribeJobQueuesPublisher
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.batch.{
  BatchAsyncClientBuilder,
  BatchAsyncClient
}
import zio.stream.ZStream
import software.amazon.awssdk.services.batch.model.{
  UpdateSchedulingPolicyResponse,
  CreateSchedulingPolicyResponse,
  SubmitJobResponse,
  SchedulingPolicyListingDetail,
  JobDefinition,
  DeregisterJobDefinitionResponse,
  ListSchedulingPoliciesResponse,
  DescribeJobDefinitionsResponse,
  CancelJobResponse,
  UpdateJobQueueResponse,
  DescribeJobsResponse,
  CreateComputeEnvironmentResponse,
  TerminateJobResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateJobQueueResponse,
  DeleteSchedulingPolicyResponse,
  RegisterJobDefinitionResponse,
  DescribeJobQueuesResponse,
  DeleteComputeEnvironmentResponse,
  DeleteJobQueueResponse,
  DescribeSchedulingPoliciesResponse,
  ListJobsResponse,
  TagResourceResponse,
  UpdateComputeEnvironmentResponse,
  JobSummary,
  ComputeEnvironmentDetail,
  DescribeComputeEnvironmentsResponse,
  JobQueueDetail
}
import scala.jdk.CollectionConverters._
trait Batch extends AspectSupport[Batch] {
  val api: BatchAsyncClient
  def submitJob(request: SubmitJobRequest): IO[AwsError, ReadOnly]
  def deleteSchedulingPolicy(
      request: DeleteSchedulingPolicyRequest
  ): IO[AwsError, zio.aws.batch.model.DeleteSchedulingPolicyResponse.ReadOnly]
  def describeComputeEnvironments(
      request: DescribeComputeEnvironmentsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly
  ]
  def describeComputeEnvironmentsPaginated(
      request: DescribeComputeEnvironmentsRequest
  ): IO[
    AwsError,
    zio.aws.batch.model.DescribeComputeEnvironmentsResponse.ReadOnly
  ]
  def registerJobDefinition(
      request: RegisterJobDefinitionRequest
  ): IO[AwsError, zio.aws.batch.model.RegisterJobDefinitionResponse.ReadOnly]
  def describeJobQueues(
      request: DescribeJobQueuesRequest
  ): ZStream[Any, AwsError, zio.aws.batch.model.JobQueueDetail.ReadOnly]
  def describeJobQueuesPaginated(
      request: DescribeJobQueuesRequest
  ): IO[AwsError, zio.aws.batch.model.DescribeJobQueuesResponse.ReadOnly]
  def describeSchedulingPolicies(
      request: DescribeSchedulingPoliciesRequest
  ): IO[
    AwsError,
    zio.aws.batch.model.DescribeSchedulingPoliciesResponse.ReadOnly
  ]
  def updateComputeEnvironment(
      request: UpdateComputeEnvironmentRequest
  ): IO[AwsError, zio.aws.batch.model.UpdateComputeEnvironmentResponse.ReadOnly]
  def createJobQueue(
      request: CreateJobQueueRequest
  ): IO[AwsError, zio.aws.batch.model.CreateJobQueueResponse.ReadOnly]
  def cancelJob(
      request: CancelJobRequest
  ): IO[AwsError, zio.aws.batch.model.CancelJobResponse.ReadOnly]
  def updateJobQueue(
      request: UpdateJobQueueRequest
  ): IO[AwsError, zio.aws.batch.model.UpdateJobQueueResponse.ReadOnly]
  def deregisterJobDefinition(
      request: DeregisterJobDefinitionRequest
  ): IO[AwsError, zio.aws.batch.model.DeregisterJobDefinitionResponse.ReadOnly]
  def terminateJob(
      request: TerminateJobRequest
  ): IO[AwsError, zio.aws.batch.model.TerminateJobResponse.ReadOnly]
  def describeJobs(
      request: DescribeJobsRequest
  ): IO[AwsError, zio.aws.batch.model.DescribeJobsResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.batch.model.UntagResourceResponse.ReadOnly]
  def createSchedulingPolicy(
      request: CreateSchedulingPolicyRequest
  ): IO[AwsError, zio.aws.batch.model.CreateSchedulingPolicyResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.batch.model.ListTagsForResourceResponse.ReadOnly]
  def listJobs(
      request: ListJobsRequest
  ): ZStream[Any, AwsError, zio.aws.batch.model.JobSummary.ReadOnly]
  def listJobsPaginated(
      request: ListJobsRequest
  ): IO[AwsError, zio.aws.batch.model.ListJobsResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.batch.model.TagResourceResponse.ReadOnly]
  def describeJobDefinitions(
      request: DescribeJobDefinitionsRequest
  ): ZStream[Any, AwsError, zio.aws.batch.model.JobDefinition.ReadOnly]
  def describeJobDefinitionsPaginated(
      request: DescribeJobDefinitionsRequest
  ): IO[AwsError, zio.aws.batch.model.DescribeJobDefinitionsResponse.ReadOnly]
  def updateSchedulingPolicy(
      request: UpdateSchedulingPolicyRequest
  ): IO[AwsError, zio.aws.batch.model.UpdateSchedulingPolicyResponse.ReadOnly]
  def createComputeEnvironment(
      request: CreateComputeEnvironmentRequest
  ): IO[AwsError, zio.aws.batch.model.CreateComputeEnvironmentResponse.ReadOnly]
  def deleteComputeEnvironment(
      request: DeleteComputeEnvironmentRequest
  ): IO[AwsError, zio.aws.batch.model.DeleteComputeEnvironmentResponse.ReadOnly]
  def listSchedulingPolicies(request: ListSchedulingPoliciesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.batch.model.SchedulingPolicyListingDetail.ReadOnly
  ]
  def listSchedulingPoliciesPaginated(
      request: ListSchedulingPoliciesRequest
  ): IO[AwsError, zio.aws.batch.model.ListSchedulingPoliciesResponse.ReadOnly]
  def deleteJobQueue(
      request: DeleteJobQueueRequest
  ): IO[AwsError, zio.aws.batch.model.DeleteJobQueueResponse.ReadOnly]
}
object Batch {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Batch] = customized(identity)
  def customized(
      customization: BatchAsyncClientBuilder => BatchAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Batch] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: BatchAsyncClientBuilder => BatchAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Batch] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = BatchAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[BatchAsyncClient, BatchAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[BatchAsyncClient, BatchAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new BatchImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class BatchImpl[R](
      override val api: BatchAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Batch
      with AwsServiceBase[R] {
    override val serviceName: String = "Batch"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): BatchImpl[R1] = new BatchImpl(api, newAspect, r)
    def submitJob(request: SubmitJobRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.batch.model.SubmitJobRequest,
        SubmitJobResponse
      ]("submitJob", api.submitJob)(request.buildAwsValue())
        .map(zio.aws.batch.model.SubmitJobResponse.wrap)
        .provideEnvironment(r)
    def deleteSchedulingPolicy(request: DeleteSchedulingPolicyRequest): IO[
      AwsError,
      zio.aws.batch.model.DeleteSchedulingPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.batch.model.DeleteSchedulingPolicyRequest,
      DeleteSchedulingPolicyResponse
    ]("deleteSchedulingPolicy", api.deleteSchedulingPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.batch.model.DeleteSchedulingPolicyResponse.wrap)
      .provideEnvironment(r)
    def describeComputeEnvironments(
        request: DescribeComputeEnvironmentsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest,
      ComputeEnvironmentDetail,
      DescribeComputeEnvironmentsPublisher
    ](
      "describeComputeEnvironments",
      api.describeComputeEnvironmentsPaginator,
      _.computeEnvironments()
    )(request.buildAwsValue())
      .map(item => zio.aws.batch.model.ComputeEnvironmentDetail.wrap(item))
      .provideEnvironment(r)
    def describeComputeEnvironmentsPaginated(
        request: DescribeComputeEnvironmentsRequest
    ): IO[
      AwsError,
      zio.aws.batch.model.DescribeComputeEnvironmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest,
      DescribeComputeEnvironmentsResponse
    ]("describeComputeEnvironments", api.describeComputeEnvironments)(
      request.buildAwsValue()
    ).map(zio.aws.batch.model.DescribeComputeEnvironmentsResponse.wrap)
      .provideEnvironment(r)
    def registerJobDefinition(request: RegisterJobDefinitionRequest): IO[
      AwsError,
      zio.aws.batch.model.RegisterJobDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.batch.model.RegisterJobDefinitionRequest,
      RegisterJobDefinitionResponse
    ]("registerJobDefinition", api.registerJobDefinition)(
      request.buildAwsValue()
    ).map(zio.aws.batch.model.RegisterJobDefinitionResponse.wrap)
      .provideEnvironment(r)
    def describeJobQueues(
        request: DescribeJobQueuesRequest
    ): ZStream[Any, AwsError, zio.aws.batch.model.JobQueueDetail.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.batch.model.DescribeJobQueuesRequest,
        JobQueueDetail,
        DescribeJobQueuesPublisher
      ]("describeJobQueues", api.describeJobQueuesPaginator, _.jobQueues())(
        request.buildAwsValue()
      ).map(item => zio.aws.batch.model.JobQueueDetail.wrap(item))
        .provideEnvironment(r)
    def describeJobQueuesPaginated(
        request: DescribeJobQueuesRequest
    ): IO[AwsError, zio.aws.batch.model.DescribeJobQueuesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.batch.model.DescribeJobQueuesRequest,
        DescribeJobQueuesResponse
      ]("describeJobQueues", api.describeJobQueues)(request.buildAwsValue())
        .map(zio.aws.batch.model.DescribeJobQueuesResponse.wrap)
        .provideEnvironment(r)
    def describeSchedulingPolicies(
        request: DescribeSchedulingPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.batch.model.DescribeSchedulingPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.batch.model.DescribeSchedulingPoliciesRequest,
      DescribeSchedulingPoliciesResponse
    ]("describeSchedulingPolicies", api.describeSchedulingPolicies)(
      request.buildAwsValue()
    ).map(zio.aws.batch.model.DescribeSchedulingPoliciesResponse.wrap)
      .provideEnvironment(r)
    def updateComputeEnvironment(request: UpdateComputeEnvironmentRequest): IO[
      AwsError,
      zio.aws.batch.model.UpdateComputeEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentRequest,
      UpdateComputeEnvironmentResponse
    ]("updateComputeEnvironment", api.updateComputeEnvironment)(
      request.buildAwsValue()
    ).map(zio.aws.batch.model.UpdateComputeEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def createJobQueue(
        request: CreateJobQueueRequest
    ): IO[AwsError, zio.aws.batch.model.CreateJobQueueResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.batch.model.CreateJobQueueRequest,
        CreateJobQueueResponse
      ]("createJobQueue", api.createJobQueue)(request.buildAwsValue())
        .map(zio.aws.batch.model.CreateJobQueueResponse.wrap)
        .provideEnvironment(r)
    def cancelJob(
        request: CancelJobRequest
    ): IO[AwsError, zio.aws.batch.model.CancelJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.batch.model.CancelJobRequest,
        CancelJobResponse
      ]("cancelJob", api.cancelJob)(request.buildAwsValue())
        .map(zio.aws.batch.model.CancelJobResponse.wrap)
        .provideEnvironment(r)
    def updateJobQueue(
        request: UpdateJobQueueRequest
    ): IO[AwsError, zio.aws.batch.model.UpdateJobQueueResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.batch.model.UpdateJobQueueRequest,
        UpdateJobQueueResponse
      ]("updateJobQueue", api.updateJobQueue)(request.buildAwsValue())
        .map(zio.aws.batch.model.UpdateJobQueueResponse.wrap)
        .provideEnvironment(r)
    def deregisterJobDefinition(request: DeregisterJobDefinitionRequest): IO[
      AwsError,
      zio.aws.batch.model.DeregisterJobDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.batch.model.DeregisterJobDefinitionRequest,
      DeregisterJobDefinitionResponse
    ]("deregisterJobDefinition", api.deregisterJobDefinition)(
      request.buildAwsValue()
    ).map(zio.aws.batch.model.DeregisterJobDefinitionResponse.wrap)
      .provideEnvironment(r)
    def terminateJob(
        request: TerminateJobRequest
    ): IO[AwsError, zio.aws.batch.model.TerminateJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.batch.model.TerminateJobRequest,
        TerminateJobResponse
      ]("terminateJob", api.terminateJob)(request.buildAwsValue())
        .map(zio.aws.batch.model.TerminateJobResponse.wrap)
        .provideEnvironment(r)
    def describeJobs(
        request: DescribeJobsRequest
    ): IO[AwsError, zio.aws.batch.model.DescribeJobsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.batch.model.DescribeJobsRequest,
        DescribeJobsResponse
      ]("describeJobs", api.describeJobs)(request.buildAwsValue())
        .map(zio.aws.batch.model.DescribeJobsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.batch.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.batch.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.batch.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createSchedulingPolicy(request: CreateSchedulingPolicyRequest): IO[
      AwsError,
      zio.aws.batch.model.CreateSchedulingPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.batch.model.CreateSchedulingPolicyRequest,
      CreateSchedulingPolicyResponse
    ]("createSchedulingPolicy", api.createSchedulingPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.batch.model.CreateSchedulingPolicyResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.batch.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.batch.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.batch.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def listJobs(
        request: ListJobsRequest
    ): ZStream[Any, AwsError, zio.aws.batch.model.JobSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.batch.model.ListJobsRequest,
        JobSummary,
        ListJobsPublisher
      ]("listJobs", api.listJobsPaginator, _.jobSummaryList())(
        request.buildAwsValue()
      ).map(item => zio.aws.batch.model.JobSummary.wrap(item))
        .provideEnvironment(r)
    def listJobsPaginated(
        request: ListJobsRequest
    ): IO[AwsError, zio.aws.batch.model.ListJobsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.batch.model.ListJobsRequest,
        ListJobsResponse
      ]("listJobs", api.listJobs)(request.buildAwsValue())
        .map(zio.aws.batch.model.ListJobsResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.batch.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.batch.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.batch.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeJobDefinitions(request: DescribeJobDefinitionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.batch.model.JobDefinition.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsRequest,
      JobDefinition,
      DescribeJobDefinitionsPublisher
    ](
      "describeJobDefinitions",
      api.describeJobDefinitionsPaginator,
      _.jobDefinitions()
    )(request.buildAwsValue())
      .map(item => zio.aws.batch.model.JobDefinition.wrap(item))
      .provideEnvironment(r)
    def describeJobDefinitionsPaginated(
        request: DescribeJobDefinitionsRequest
    ): IO[
      AwsError,
      zio.aws.batch.model.DescribeJobDefinitionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsRequest,
      DescribeJobDefinitionsResponse
    ]("describeJobDefinitions", api.describeJobDefinitions)(
      request.buildAwsValue()
    ).map(zio.aws.batch.model.DescribeJobDefinitionsResponse.wrap)
      .provideEnvironment(r)
    def updateSchedulingPolicy(request: UpdateSchedulingPolicyRequest): IO[
      AwsError,
      zio.aws.batch.model.UpdateSchedulingPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.batch.model.UpdateSchedulingPolicyRequest,
      UpdateSchedulingPolicyResponse
    ]("updateSchedulingPolicy", api.updateSchedulingPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.batch.model.UpdateSchedulingPolicyResponse.wrap)
      .provideEnvironment(r)
    def createComputeEnvironment(request: CreateComputeEnvironmentRequest): IO[
      AwsError,
      zio.aws.batch.model.CreateComputeEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentRequest,
      CreateComputeEnvironmentResponse
    ]("createComputeEnvironment", api.createComputeEnvironment)(
      request.buildAwsValue()
    ).map(zio.aws.batch.model.CreateComputeEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def deleteComputeEnvironment(request: DeleteComputeEnvironmentRequest): IO[
      AwsError,
      zio.aws.batch.model.DeleteComputeEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.batch.model.DeleteComputeEnvironmentRequest,
      DeleteComputeEnvironmentResponse
    ]("deleteComputeEnvironment", api.deleteComputeEnvironment)(
      request.buildAwsValue()
    ).map(zio.aws.batch.model.DeleteComputeEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def listSchedulingPolicies(request: ListSchedulingPoliciesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.batch.model.SchedulingPolicyListingDetail.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesRequest,
      SchedulingPolicyListingDetail,
      ListSchedulingPoliciesPublisher
    ](
      "listSchedulingPolicies",
      api.listSchedulingPoliciesPaginator,
      _.schedulingPolicies()
    )(request.buildAwsValue())
      .map(item => zio.aws.batch.model.SchedulingPolicyListingDetail.wrap(item))
      .provideEnvironment(r)
    def listSchedulingPoliciesPaginated(
        request: ListSchedulingPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.batch.model.ListSchedulingPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesRequest,
      ListSchedulingPoliciesResponse
    ]("listSchedulingPolicies", api.listSchedulingPolicies)(
      request.buildAwsValue()
    ).map(zio.aws.batch.model.ListSchedulingPoliciesResponse.wrap)
      .provideEnvironment(r)
    def deleteJobQueue(
        request: DeleteJobQueueRequest
    ): IO[AwsError, zio.aws.batch.model.DeleteJobQueueResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.batch.model.DeleteJobQueueRequest,
        DeleteJobQueueResponse
      ]("deleteJobQueue", api.deleteJobQueue)(request.buildAwsValue())
        .map(zio.aws.batch.model.DeleteJobQueueResponse.wrap)
        .provideEnvironment(r)
  }
  def submitJob(
      request: SubmitJobRequest
  ): ZIO[zio.aws.batch.Batch, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.submitJob(request))
  def deleteSchedulingPolicy(request: DeleteSchedulingPolicyRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.DeleteSchedulingPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSchedulingPolicy(request))
  def describeComputeEnvironments(
      request: DescribeComputeEnvironmentsRequest
  ): ZStream[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly
  ] = ZStream.serviceWithStream(_.describeComputeEnvironments(request))
  def describeComputeEnvironmentsPaginated(
      request: DescribeComputeEnvironmentsRequest
  ): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.DescribeComputeEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeComputeEnvironmentsPaginated(request))
  def registerJobDefinition(request: RegisterJobDefinitionRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.RegisterJobDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerJobDefinition(request))
  def describeJobQueues(request: DescribeJobQueuesRequest): ZStream[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.JobQueueDetail.ReadOnly
  ] = ZStream.serviceWithStream(_.describeJobQueues(request))
  def describeJobQueuesPaginated(request: DescribeJobQueuesRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.DescribeJobQueuesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeJobQueuesPaginated(request))
  def describeSchedulingPolicies(
      request: DescribeSchedulingPoliciesRequest
  ): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.DescribeSchedulingPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSchedulingPolicies(request))
  def updateComputeEnvironment(request: UpdateComputeEnvironmentRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.UpdateComputeEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateComputeEnvironment(request))
  def createJobQueue(request: CreateJobQueueRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.CreateJobQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createJobQueue(request))
  def cancelJob(request: CancelJobRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.CancelJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelJob(request))
  def updateJobQueue(request: UpdateJobQueueRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.UpdateJobQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateJobQueue(request))
  def deregisterJobDefinition(request: DeregisterJobDefinitionRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.DeregisterJobDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterJobDefinition(request))
  def terminateJob(request: TerminateJobRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.TerminateJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.terminateJob(request))
  def describeJobs(request: DescribeJobsRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.DescribeJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeJobs(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createSchedulingPolicy(request: CreateSchedulingPolicyRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.CreateSchedulingPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSchedulingPolicy(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listJobs(request: ListJobsRequest): ZStream[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.JobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobs(request))
  def listJobsPaginated(request: ListJobsRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.ListJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobsPaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def describeJobDefinitions(request: DescribeJobDefinitionsRequest): ZStream[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.JobDefinition.ReadOnly
  ] = ZStream.serviceWithStream(_.describeJobDefinitions(request))
  def describeJobDefinitionsPaginated(
      request: DescribeJobDefinitionsRequest
  ): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.DescribeJobDefinitionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeJobDefinitionsPaginated(request))
  def updateSchedulingPolicy(request: UpdateSchedulingPolicyRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.UpdateSchedulingPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSchedulingPolicy(request))
  def createComputeEnvironment(request: CreateComputeEnvironmentRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.CreateComputeEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createComputeEnvironment(request))
  def deleteComputeEnvironment(request: DeleteComputeEnvironmentRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.DeleteComputeEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteComputeEnvironment(request))
  def listSchedulingPolicies(request: ListSchedulingPoliciesRequest): ZStream[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.SchedulingPolicyListingDetail.ReadOnly
  ] = ZStream.serviceWithStream(_.listSchedulingPolicies(request))
  def listSchedulingPoliciesPaginated(
      request: ListSchedulingPoliciesRequest
  ): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.ListSchedulingPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSchedulingPoliciesPaginated(request))
  def deleteJobQueue(request: DeleteJobQueueRequest): ZIO[
    zio.aws.batch.Batch,
    AwsError,
    zio.aws.batch.model.DeleteJobQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteJobQueue(request))
}
