package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksHostPath(path: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksHostPath = {
    import EksHostPath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksHostPath
      .builder()
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksHostPath.ReadOnly =
    zio.aws.batch.model.EksHostPath.wrap(buildAwsValue())
}
object EksHostPath {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.EksHostPath] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksHostPath =
      zio.aws.batch.model.EksHostPath(path.map(value => value))
    def path: Optional[String]
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksHostPath
  ) extends zio.aws.batch.model.EksHostPath.ReadOnly {
    override val path: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksHostPath
  ): zio.aws.batch.model.EksHostPath.ReadOnly = new Wrapper(impl)
}
