package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Secret(name: String, valueFrom: String) {
  def buildAwsValue(): software.amazon.awssdk.services.batch.model.Secret = {
    import Secret.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.Secret
      .builder()
      .name(name: java.lang.String)
      .valueFrom(valueFrom: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.Secret.ReadOnly =
    zio.aws.batch.model.Secret.wrap(buildAwsValue())
}
object Secret {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.Secret] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.Secret =
      zio.aws.batch.model.Secret(name, valueFrom)
    def name: String
    def valueFrom: String
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getValueFrom: ZIO[Any, Nothing, String] = ZIO.succeed(valueFrom)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.Secret
  ) extends zio.aws.batch.model.Secret.ReadOnly {
    override val name: String = impl.name(): String
    override val valueFrom: String = impl.valueFrom(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.Secret
  ): zio.aws.batch.model.Secret.ReadOnly = new Wrapper(impl)
}
