package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NodeRangeProperty(
    targetNodes: String,
    container: Optional[zio.aws.batch.model.ContainerProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.NodeRangeProperty = {
    import NodeRangeProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.NodeRangeProperty
      .builder()
      .targetNodes(targetNodes: java.lang.String)
      .optionallyWith(container.map(value => value.buildAwsValue()))(
        _.container
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.NodeRangeProperty.ReadOnly =
    zio.aws.batch.model.NodeRangeProperty.wrap(buildAwsValue())
}
object NodeRangeProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.NodeRangeProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.NodeRangeProperty = zio.aws.batch.model
      .NodeRangeProperty(targetNodes, container.map(value => value.asEditable))
    def targetNodes: String
    def container: Optional[zio.aws.batch.model.ContainerProperties.ReadOnly]
    def getTargetNodes: ZIO[Any, Nothing, String] = ZIO.succeed(targetNodes)
    def getContainer
        : ZIO[Any, AwsError, zio.aws.batch.model.ContainerProperties.ReadOnly] =
      AwsError.unwrapOptionField("container", container)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.NodeRangeProperty
  ) extends zio.aws.batch.model.NodeRangeProperty.ReadOnly {
    override val targetNodes: String = impl.targetNodes(): String
    override val container
        : Optional[zio.aws.batch.model.ContainerProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.container())
        .map(value => zio.aws.batch.model.ContainerProperties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.NodeRangeProperty
  ): zio.aws.batch.model.NodeRangeProperty.ReadOnly = new Wrapper(impl)
}
